/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.expr;

import au.com.ordermate.expr.Symbol;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class SymbolTree
extends Symbol {
    private int modCount = 0;
    private static int nextIteratorID = 1;

    public SymbolTree() {
        super("ROOT");
    }

    void incModCount() {
        ++this.modCount;
    }

    int getModCount() {
        return this.modCount;
    }

    public TreeIterator depthFirstIterator() {
        return new DepthFirstIterator();
    }

    public TreeIterator depthFirstIterator(boolean reverse) {
        if (reverse) {
            return new ReverseDepthFirstIterator();
        }
        return new DepthFirstIterator();
    }

    @Override
    public boolean promote() {
        return false;
    }

    @Override
    public boolean demote() {
        return false;
    }

    @Override
    public boolean capturePreviousPeer() {
        return false;
    }

    @Override
    public boolean captureNextPeer() {
        return false;
    }

    @Override
    public boolean captureNeighbours() {
        return false;
    }

    @Override
    public boolean delete() {
        return false;
    }

    static /* synthetic */ int access$008() {
        return nextIteratorID++;
    }

    public class ReverseDepthFirstIterator
    extends IteratorImpl {
        @Override
        protected Symbol selectNext(Symbol fromSymbol) {
            if (this.current != null) {
                Symbol retval = fromSymbol;
                while (retval != null && retval.getLastIterID() == this.id) {
                    Symbol parent = retval.getParent();
                    Symbol child = retval.getLastChild();
                    Symbol prevPeer = retval.getPreviousPeer();
                    if (child != null) {
                        retval = child;
                        continue;
                    }
                    if (prevPeer != null) {
                        retval = prevPeer;
                        continue;
                    }
                    if (parent != null && parent != SymbolTree.this) {
                        do {
                            retval = parent.getPreviousPeer();
                            parent = parent.getParent();
                        } while (retval == null && parent != null);
                        continue;
                    }
                    retval = null;
                }
                return retval;
            }
            return null;
        }
    }

    public class DepthFirstIterator
    extends IteratorImpl {
        @Override
        protected Symbol selectNext(Symbol fromSymbol) {
            if (this.current != null) {
                Symbol retval = fromSymbol;
                while (retval != null && retval.getLastIterID() == this.id) {
                    Symbol parent = retval.getParent();
                    Symbol child = retval.getFirstChild();
                    Symbol nextPeer = retval.getNextPeer();
                    if (child != null) {
                        retval = child;
                        continue;
                    }
                    if (nextPeer != null) {
                        retval = nextPeer;
                        continue;
                    }
                    if (parent != null && parent != SymbolTree.this) {
                        do {
                            retval = parent.getNextPeer();
                            parent = parent.getParent();
                        } while (retval == null && parent != null);
                        continue;
                    }
                    retval = null;
                }
                return retval;
            }
            return null;
        }
    }

    private abstract class IteratorImpl
    implements TreeIterator {
        protected int id = SymbolTree.access$008();
        protected int expectedModCount = SymbolTree.this.getModCount();
        protected Symbol current = SymbolTree.this;
        protected Symbol lastReturned = null;

        IteratorImpl() {
            this.next();
            SymbolTree.this.setLastIterID(this.id);
            this.lastReturned = null;
        }

        protected void checkForComodification() {
            if (this.expectedModCount < SymbolTree.this.getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public final Object next() {
            Symbol retval = this.current;
            this.current.setLastIterID(this.id);
            this.current = this.selectNext(this.current);
            this.lastReturned = retval;
            return retval;
        }

        protected abstract Symbol selectNext(Symbol var1);

        @Override
        public void promote() {
            this.checkForComodification();
            this.lastReturned.promote();
            this.current = this.selectNext(this.current);
            this.expectedModCount = SymbolTree.this.getModCount();
        }

        @Override
        public void demote() {
            this.checkForComodification();
            this.lastReturned.demote();
            this.current = this.selectNext(this.current);
            this.expectedModCount = SymbolTree.this.getModCount();
        }

        @Override
        public void capturePreviousPeer() {
            this.checkForComodification();
            this.lastReturned.capturePreviousPeer();
            this.current = this.selectNext(this.current);
            this.expectedModCount = SymbolTree.this.getModCount();
        }

        @Override
        public void captureNextPeer() {
            this.checkForComodification();
            this.lastReturned.captureNextPeer();
            this.current = this.selectNext(this.current);
            this.expectedModCount = SymbolTree.this.getModCount();
        }

        @Override
        public void captureNeighbours() {
            this.checkForComodification();
            this.lastReturned.captureNeighbours();
            this.current = this.selectNext(this.current);
            this.expectedModCount = SymbolTree.this.getModCount();
        }

        @Override
        public void remove() {
            this.checkForComodification();
            this.current = this.selectNext(this.current);
            this.lastReturned.delete();
            this.expectedModCount = SymbolTree.this.getModCount();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }
    }

    public static interface TreeIterator
    extends Iterator {
        public void promote();

        public void demote();

        public void capturePreviousPeer();

        public void captureNextPeer();

        public void captureNeighbours();
    }
}

