/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.gateway;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayAuthorizer;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.gateway.GatewayProcessor;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class DequeGateway<T>
extends Gateway<T> {
    public DequeGateway(GatewayProcessor processor, GatewayNotifier notifier, GatewayAuthorizer authorizer, int queueSize) {
        super(processor, notifier, authorizer, queueSize);
    }

    @Override
    protected BlockingQueue<T> createBlockingQueue(int queueSize) {
        return new LinkedBlockingDeque(queueSize);
    }

    @Override
    public boolean putIntoQueue(T toPut) {
        return this.putIntoQueue(toPut, false);
    }

    public boolean putIntoQueue(T toPut, boolean front) {
        boolean added = false;
        try {
            if (this.getMyAuthorizer().authorize(this.getIncomingQueue(), toPut)) {
                added = front ? ((BlockingDeque)this.getIncomingQueue()).offerFirst(toPut, this.getPutTimeout(), TimeUnit.MILLISECONDS) : ((BlockingDeque)this.getIncomingQueue()).offerLast(toPut, this.getPutTimeout(), TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException ex) {
            OrderMateLog.LOG.warn("Interrupted while adding to the incoming queue:", (Throwable)ex);
        }
        return added;
    }
}

