/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.gateway;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gateway.DefaultGatewayAuthorizer;
import au.com.ordermate.gateway.GatewayAuthorizer;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.gateway.GatewayProcessor;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Gateway<T> {
    private static final int DEFAULT_QUEUE_SIZE = 20;
    private static final int DEFAULT_PUT_TIMEOUT = 1000;
    private static final int DEFAULT_POLL_TIMEOUT = 5000;
    private int putTimeout = 1000;
    private int pollTimeout = 5000;
    private BlockingQueue<T> incomingQueue;
    private GatewayProcessor<T> myProcessor;
    private GatewayNotifier<T> myNotifier;
    private GatewayAuthorizer<T> myAuthorizer;
    private boolean running;
    private Thread workingThread;

    public Gateway(GatewayProcessor<T> processor, GatewayNotifier<T> notifier) {
        this(processor, notifier, 20);
    }

    public Gateway(GatewayProcessor<T> processor, GatewayNotifier<T> notifier, int queueSize) {
        this(processor, notifier, new DefaultGatewayAuthorizer(), queueSize);
    }

    public Gateway(GatewayProcessor<T> processor, GatewayNotifier<T> notifier, GatewayAuthorizer<T> authorizer, int queueSize) {
        this.myProcessor = processor;
        if (this.myProcessor == null) {
            throw new IllegalArgumentException("The Gateway must have a processor to process incoming objects.");
        }
        this.myNotifier = notifier;
        this.myAuthorizer = authorizer;
        this.incomingQueue = this.createBlockingQueue(queueSize);
    }

    protected BlockingQueue<T> createBlockingQueue(int queueSize) {
        return new ArrayBlockingQueue(queueSize);
    }

    public void setPutTimeout(int value) {
        this.putTimeout = value;
    }

    public void setPollTimeout(int value) {
        if (value > 0) {
            this.pollTimeout = value;
        }
    }

    public int getPutTimeout() {
        return this.putTimeout;
    }

    public BlockingQueue<T> getIncomingQueue() {
        return this.incomingQueue;
    }

    public GatewayAuthorizer<T> getMyAuthorizer() {
        return this.myAuthorizer;
    }

    public boolean putIntoQueue(T toPut) {
        boolean added = false;
        try {
            added = this.incomingQueue.offer(toPut, this.putTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            OrderMateLog.LOG.warn("Interrupted while adding to the incoming queue:", (Throwable)ex);
        }
        return added;
    }

    public boolean removeTaskFromQueue(T element) {
        boolean removed = false;
        try {
            if (element == null) {
                Logger.getGlobal().info("Returning false since item to be removed is null ");
                return false;
            }
            if (this.incomingQueue.contains(element)) {
                removed = this.incomingQueue.remove(element);
                if (removed) {
                    Logger.getGlobal().info("Removed Item " + removed + " from Queue");
                } else {
                    Logger.getGlobal().info("Removal of Item " + element + " was not successful");
                }
            } else {
                Logger.getGlobal().info("Item to be removed is NOT present in the queue");
            }
        }
        catch (Exception ie) {
            Logger.getGlobal().info("Interrupted while removing to the incoming queue");
            removed = false;
        }
        return removed;
    }

    public void stopService() {
        this.running = false;
    }

    public void startService() {
        this.running = true;
        Runnable localService = new Runnable(){

            @Override
            public void run() {
                while (Gateway.this.running) {
                    Object incoming = null;
                    try {
                        incoming = Gateway.this.incomingQueue.poll(Gateway.this.pollTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ex) {
                        OrderMateLog.LOG.warn("Interrupted while waiting for incoming objects.", (Throwable)ex);
                    }
                    if (incoming == null) continue;
                    try {
                        boolean value = Gateway.this.myProcessor.processIncoming(incoming);
                        if (Gateway.this.myNotifier == null) continue;
                        Gateway.this.myNotifier.notifyProcess(incoming, value);
                    }
                    catch (Exception ex) {
                        Logger.getGlobal().log(Level.WARNING, "Exception processing incoming object, notifying error.", ex);
                        if (Gateway.this.myNotifier == null) continue;
                        Gateway.this.myNotifier.notifyProcess(incoming, false);
                    }
                }
            }
        };
        this.workingThread = new Thread(localService);
        this.workingThread.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAuthorised(T entity) {
        return this.myAuthorizer.authorize(this.incomingQueue, entity);
    }
}

