/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.glazedlists;

import au.com.ordermate.glazedlists.TermPrefixMatcher;
import au.com.ordermate.util.Stringifier;
import au.com.ordermate.util.ToStringifier;
import java.util.Comparator;

public class CountedPrefixComparator<T>
implements Comparator<T> {
    private String[] prefixTerms;
    private Stringifier<T> stringifier = new ToStringifier();

    public CountedPrefixComparator() {
        this.prefixTerms = new String[0];
    }

    public void setSearchString(String value) {
        this.prefixTerms = value == null ? new String[0] : TermPrefixMatcher.splitToTerms(value, true, true);
    }

    public void setStringifer(Stringifier<T> value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot set a null stringifier");
        }
        this.stringifier = value;
    }

    @Override
    public int compare(T first, T second) {
        if (this.prefixTerms.length == 0) {
            return 0;
        }
        String[] firstString = TermPrefixMatcher.splitToTerms(this.stringifier.stringify(first), true, true);
        String[] secondString = TermPrefixMatcher.splitToTerms(this.stringifier.stringify(second), true, true);
        int firstCount = 0;
        int secondCount = 0;
        for (int i = 0; i < this.prefixTerms.length; ++i) {
            int j;
            for (j = 0; j < firstString.length; ++j) {
                if (!firstString[j].startsWith(this.prefixTerms[i])) continue;
                ++firstCount;
            }
            for (j = 0; j < secondString.length; ++j) {
                if (!secondString[j].startsWith(this.prefixTerms[i])) continue;
                ++secondCount;
            }
        }
        return secondCount - firstCount;
    }
}

