/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.glazedlists;

import ca.odell.glazedlists.EventList;
import java.util.Collection;
import java.util.List;

public class GlazedListUtils {
    public static <T> void clearAll(EventList<? super T> eventList) {
        GlazedListUtils.GetWriteAndReadLock(eventList);
        try {
            eventList.clear();
        }
        finally {
            GlazedListUtils.ReleaseWriteAndReadLock(eventList);
        }
    }

    public static <T> void setAsList(EventList<? super T> eventList, Collection<T> toSet) {
        GlazedListUtils.GetWriteAndReadLock(eventList);
        try {
            eventList.clear();
            eventList.addAll(toSet);
        }
        finally {
            GlazedListUtils.ReleaseWriteAndReadLock(eventList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean replace(EventList<? super T> eventList, T origObj, T newObj) {
        GlazedListUtils.GetWriteAndReadLock(eventList);
        try {
            int index = eventList.indexOf(origObj);
            if (index > -1) {
                eventList.set(index, newObj);
            }
            boolean bl = index > -1;
            return bl;
        }
        finally {
            GlazedListUtils.ReleaseWriteAndReadLock(eventList);
        }
    }

    public static <T> void add(EventList<? super T> eventList, T newObj) {
        GlazedListUtils.GetWriteAndReadLock(eventList);
        try {
            eventList.add(newObj);
        }
        finally {
            GlazedListUtils.ReleaseWriteAndReadLock(eventList);
        }
    }

    public static <T> boolean delete(EventList<? super T> eventList, T toDelete) {
        GlazedListUtils.GetWriteAndReadLock(eventList);
        try {
            boolean bl = eventList.remove(toDelete);
            return bl;
        }
        finally {
            GlazedListUtils.ReleaseWriteAndReadLock(eventList);
        }
    }

    public static <T> void removeInList(EventList<? super T> eventList, List<T> toRemove) {
        GlazedListUtils.GetWriteAndReadLock(eventList);
        try {
            eventList.removeAll(toRemove);
        }
        finally {
            GlazedListUtils.ReleaseWriteAndReadLock(eventList);
        }
    }

    private static void GetWriteAndReadLock(EventList eventList) {
        eventList.getReadWriteLock().writeLock().lock();
        eventList.getReadWriteLock().readLock().lock();
    }

    private static void ReleaseWriteAndReadLock(EventList eventList) {
        eventList.getReadWriteLock().writeLock().unlock();
        eventList.getReadWriteLock().readLock().unlock();
    }
}

