/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.glazedlists;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import java.util.Collection;
import java.util.Comparator;

public class PropertyAccessorComparator<T extends PropertiedObject>
implements Comparator<T> {
    private int negate = 1;
    private PropertyAccessor accessor;

    public PropertyAccessorComparator(PropertyAccessor comparisonProperty) {
        this.accessor = comparisonProperty;
    }

    public PropertyAccessorComparator(PropertyAccessor comparisonProperty, boolean negate) {
        this.accessor = comparisonProperty;
        this.negate = negate ? -1 : 1;
    }

    public PropertyAccessorComparator negate(boolean negated) {
        this.negate = negated ? -1 : 1;
        return this;
    }

    @Override
    public int compare(T o1, T o2) {
        Comparable value1 = this.resolveValue((PropertiedObject)o1);
        Comparable value2 = this.resolveValue((PropertiedObject)o2);
        if (value1 == null) {
            if (value2 == null) {
                return 0;
            }
            return 1 * this.negate;
        }
        if (value2 == null) {
            return -1 * this.negate;
        }
        return value1.compareTo(value2) * this.negate;
    }

    protected Comparable resolveValue(PropertiedObject object) {
        Object value = this.accessor.resolveValue(object);
        if (value == null || value instanceof Comparable) {
            return (Comparable)value;
        }
        if (value instanceof Collection) {
            if (((Collection)value).isEmpty()) {
                return null;
            }
            value = ((Collection)value).iterator().next();
        }
        if (value == null || value instanceof Comparable) {
            return (Comparable)value;
        }
        return String.valueOf(value);
    }
}

