/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.glazedlists;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PropertyMatcher<E extends PropertiedObject>
implements Matcher<E> {
    private PropertyAccessor prop;
    private Set<Object> values;

    public PropertyMatcher(PropertyAccessor property) {
        this.prop = property;
        this.values = new HashSet<Object>();
    }

    public void clearMatchValue() {
        this.values.clear();
    }

    public void setMatchValue(Object value) {
        this.values.clear();
        this.values.add(value);
    }

    public void setMatchValues(Collection<?> collection) {
        this.values.clear();
        this.values.addAll(collection);
    }

    public boolean matches(E object) {
        Object value = this.prop.resolveValue(object);
        if (value instanceof Iterable) {
            for (Object nextValue : (Iterable)value) {
                if (!this.values.contains(nextValue)) continue;
                return true;
            }
        }
        return this.values.contains(value);
    }
}

