/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.glazedlists;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SequentialComparator<T>
implements Comparator<T> {
    private ArrayList<Comparator<T>> comps = new ArrayList();

    public SequentialComparator() {
    }

    public SequentialComparator(List<Comparator<T>> comparators) {
        if (comparators != null) {
            this.comps.addAll(comparators);
        }
    }

    public void addComparator(Comparator<T> compToAdd) {
        if (compToAdd != null && !this.comps.contains(compToAdd)) {
            this.comps.add(compToAdd);
        }
    }

    public void removeComparator(Comparator<T> toRemove) {
        if (toRemove != null) {
            this.comps.remove(toRemove);
        }
    }

    @Override
    public int compare(T first, T second) {
        Comparator<T> comp;
        int result = 0;
        Iterator<Comparator<T>> iterator = this.comps.iterator();
        while (iterator.hasNext() && (result = (comp = iterator.next()).compare(first, second)) == 0) {
        }
        return result;
    }

    public void clear() {
        this.comps.clear();
    }
}

