/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.glazedlists;

import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;

public abstract class TermPrefixMatcher<E>
implements Matcher<E> {
    private String[] prefixes;
    private boolean contains = false;

    public TermPrefixMatcher() {
        this.prefixes = new String[0];
    }

    public TermPrefixMatcher(String[] prefixArray) {
        this.prefixes = prefixArray;
    }

    public void setContains(boolean value) {
        this.contains = true;
    }

    public abstract void setPrefixString(String var1);

    public void setPrefixTerms(String[] prefixArray) {
        this.prefixes = prefixArray;
    }

    public boolean matches(E value) {
        String[] splits = this.getPrefixTerms(value);
        boolean fine = true;
        for (int i = 0; i < this.prefixes.length; ++i) {
            fine = false;
            if (i < splits.length) {
                for (int j = 0; j < splits.length; ++j) {
                    if (!(this.contains ? splits[j].contains(this.prefixes[i]) : splits[j].startsWith(this.prefixes[i]))) continue;
                    fine = true;
                    j = splits.length;
                }
            }
            if (fine) continue;
            i = this.prefixes.length;
        }
        return fine;
    }

    public static String[] splitToTerms(String value, boolean byUpperCase, boolean byWhitespace) {
        String toAdd;
        if (value == null) {
            return new String[0];
        }
        ArrayList<String> bits = new ArrayList<String>();
        int index = 0;
        for (int i = 0; i < value.length(); ++i) {
            char nextChar = value.charAt(i);
            if ((!byUpperCase || !Character.isUpperCase(nextChar)) && (!byWhitespace || !Character.isWhitespace(nextChar))) continue;
            if (index >= 0 && !(toAdd = value.substring(index, i).trim().toLowerCase()).isEmpty()) {
                bits.add(toAdd);
            }
            index = i;
        }
        if (index >= 0 && index < value.length() && !(toAdd = value.substring(index).trim().toLowerCase()).isEmpty()) {
            bits.add(toAdd);
        }
        String[] terms = new String[bits.size()];
        terms = bits.toArray(terms);
        return terms;
    }

    protected abstract String[] getPrefixTerms(E var1);

    public String[] getPrefixStringsToMatch() {
        return this.prefixes;
    }
}

