/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.glazedlists;

import java.util.Comparator;
import javax.swing.tree.TreeNode;

public abstract class TreeNodeComparator<T>
implements Comparator<T> {
    protected TreeNode node;

    public TreeNodeComparator() {
        this(null);
    }

    public TreeNodeComparator(TreeNode preferredNode) {
        this.setTreeNode(preferredNode);
    }

    public void setTreeNode(TreeNode preferredGroup) {
        this.node = preferredGroup;
    }

    protected abstract TreeNode extractNode(Object var1);

    @Override
    public int compare(T firstItem, T secondItem) {
        if (this.node != null) {
            return this.compareOnGroup(this.extractNode(firstItem), this.extractNode(secondItem));
        }
        return 0;
    }

    private int compareOnGroup(TreeNode firstNode, TreeNode secondNode) {
        int comparison = 0;
        if (this.node.equals(firstNode)) {
            if (!this.node.equals(secondNode)) {
                comparison = -1;
            }
        } else if (this.node.equals(secondNode)) {
            comparison = 1;
        } else if (TreeNodeComparator.isAncestorOf(this.node, firstNode)) {
            if (!TreeNodeComparator.isAncestorOf(this.node, secondNode)) {
                comparison = -1;
            }
        } else if (TreeNodeComparator.isAncestorOf(this.node, secondNode)) {
            comparison = 1;
        }
        return comparison;
    }

    public static boolean isAncestorOf(TreeNode susParent, TreeNode susChild) {
        TreeNode parent;
        if (susParent == susChild) {
            return false;
        }
        for (parent = susChild; parent != null && !parent.equals(susParent); parent = parent.getParent()) {
        }
        return parent != null;
    }
}

