/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.gui;

import au.com.ordermate.util.image.IconLoader;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class CompositeIconGenerator {
    private final List<String> icons = new ArrayList<String>();
    int iconWidth;
    int defaultPad = 1;
    int height;
    private final int ORIENTATION;

    public CompositeIconGenerator(int size) {
        this(size, 1);
    }

    public CompositeIconGenerator(int size, int orientation) {
        this.iconWidth = size;
        this.height = size;
        this.ORIENTATION = orientation;
    }

    public void addIcon(String icon) {
        this.icons.add(icon);
    }

    public void setIconWidth(int width) {
        this.iconWidth = width;
    }

    public void setIconHeight(int newHeight) {
        this.height = newHeight;
    }

    public void setPad(int pad) {
        this.defaultPad = pad;
    }

    private int getWidth() {
        if (this.ORIENTATION == 1) {
            return this.iconWidth;
        }
        return this.iconWidth * this.icons.size() + this.defaultPad * (this.icons.size() - 1);
    }

    private int getHeight() {
        if (this.ORIENTATION == 1) {
            return this.height * this.icons.size() + this.defaultPad * (this.icons.size() - 1);
        }
        return this.height;
    }

    public String generateIcon() {
        StringBuilder SB = new StringBuilder("GENERATED");
        for (String path : this.icons) {
            SB.append(path);
        }
        String label = SB.toString();
        if (IconLoader.getCached(label) == null) {
            int currentOffset = 0;
            GraphicsConfiguration gConf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            BufferedImage mainIcon = gConf.createCompatibleImage(this.getWidth(), this.getHeight(), 3);
            for (String path : this.icons) {
                ImageIcon plusIcon = IconLoader.get(path);
                if (this.ORIENTATION == 1) {
                    ((Image)mainIcon).getGraphics().drawImage(plusIcon.getImage(), 0, currentOffset, null);
                    currentOffset += this.height + this.defaultPad;
                    continue;
                }
                ((Image)mainIcon).getGraphics().drawImage(plusIcon.getImage(), currentOffset, 0, null);
                currentOffset += this.iconWidth + this.defaultPad;
            }
            IconLoader.put(label, new ImageIcon(mainIcon));
        }
        return label;
    }
}

