/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Hashtable;

public class GraphPaperLayout
implements LayoutManager2 {
    int hgap;
    int vgap;
    Dimension gridSize;
    Hashtable compTable;

    public GraphPaperLayout() {
        this(new Dimension(1, 1));
    }

    public GraphPaperLayout(Dimension theGridSize) {
        this(theGridSize, 0, 0);
    }

    public GraphPaperLayout(int width, int height) {
        this(new Dimension(width, height), 0, 0);
    }

    public GraphPaperLayout(Dimension theGridSize, int hGap, int vGap) {
        if (theGridSize.width <= 0 || theGridSize.height <= 0) {
            throw new IllegalArgumentException("dimensions must be greater than zero");
        }
        this.gridSize = new Dimension(theGridSize);
        this.hgap = hGap;
        this.vgap = vGap;
        this.compTable = new Hashtable();
    }

    public Dimension getGridSize() {
        return new Dimension(this.gridSize);
    }

    public void setGridSize(Dimension d) {
        this.setGridSize(d.width, d.height);
    }

    public void setGridSize(int width, int height) {
        this.gridSize = new Dimension(width, height);
    }

    public void setConstraints(Component comp, Rectangle constraints) {
        this.compTable.put(comp, new Rectangle(constraints));
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.compTable.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, false);
    }

    protected Dimension getLayoutSize(Container parent, boolean isPreferred) {
        Dimension largestSize = this.getLargestCellSize(parent, isPreferred);
        Insets insets = parent.getInsets();
        largestSize.width = largestSize.width * this.gridSize.width + this.hgap * (this.gridSize.width + 1) + insets.left + insets.right;
        largestSize.height = largestSize.height * this.gridSize.height + this.vgap * (this.gridSize.height + 1) + insets.top + insets.bottom;
        return largestSize;
    }

    protected Dimension getLargestCellSize(Container parent, boolean isPreferred) {
        int ncomponents = parent.getComponentCount();
        Dimension maxCellSize = new Dimension(0, 0);
        for (int i = 0; i < ncomponents; ++i) {
            Component c = parent.getComponent(i);
            Rectangle rect = (Rectangle)this.compTable.get(c);
            if (rect == null) continue;
            Dimension componentSize = isPreferred ? c.getPreferredSize() : c.getMinimumSize();
            maxCellSize.width = Math.max(maxCellSize.width, componentSize.width / rect.width);
            maxCellSize.height = Math.max(maxCellSize.height, componentSize.height / rect.height);
        }
        return maxCellSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            if (ncomponents == 0) {
                return;
            }
            Dimension size = parent.getSize();
            double totalW = size.width - (insets.left + insets.right);
            double totalH = size.height - (insets.top + insets.bottom);
            double totalCellW = totalW / (double)this.gridSize.width;
            double totalCellH = totalH / (double)this.gridSize.height;
            double cellW = (totalW - (double)((this.gridSize.width + 1) * this.hgap)) / (double)this.gridSize.width;
            double cellH = (totalH - (double)((this.gridSize.height + 1) * this.vgap)) / (double)this.gridSize.height;
            boolean leftToRight = parent.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < ncomponents; ++i) {
                Component c = parent.getComponent(i);
                Rectangle rect = (Rectangle)this.compTable.get(c);
                if (rect == null) continue;
                int rectX = rect.x;
                if (!leftToRight) {
                    int width = this.getGridSize().width;
                    rectX = width - 1 - rectX;
                }
                int x = (int)((double)insets.left + totalCellW * (double)rectX + (double)this.hgap);
                int y = (int)((double)insets.top + totalCellH * (double)rect.y + (double)this.vgap);
                int w = (int)(cellW * (double)rect.width - (double)this.hgap);
                int h = (int)(cellH * (double)rect.height - (double)this.vgap);
                c.setBounds(x, y, w, h);
            }
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof Rectangle) {
            Rectangle rect = (Rectangle)constraints;
            if (rect.width <= 0 || rect.height <= 0) {
                throw new IllegalArgumentException("cannot add to layout: rectangle must have positive width and height");
            }
            if (rect.x < 0 || rect.y < 0) {
                throw new IllegalArgumentException("cannot add to layout: rectangle x and y must be >= 0");
            }
            this.setConstraints(comp, rect);
        } else if (constraints != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a Rectangle");
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

