/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.gui;

import au.com.ordermate.gui.ObjectEditedListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ObjectEditedDespatch {
    private Map<Class, List<ObjectEditedListener>> listenerListMap = new HashMap<Class, List<ObjectEditedListener>>();
    private static final ObjectEditedDespatch instance = new ObjectEditedDespatch();

    public static final ObjectEditedDespatch getInstance() {
        return instance;
    }

    public final void fireObjectEdited(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot modify a null value.");
        }
        this.fireObjectEdited(value.getClass());
    }

    public final void fireObjectEdited(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Cannot modify null class.");
        }
        List<ObjectEditedListener> list = this.listenerListMap.get(clazz);
        if (list != null) {
            for (ObjectEditedListener listener : list) {
                listener.objectEdited(clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Class clazz, ObjectEditedListener listener) {
        Object object;
        if (listener == null) {
            throw new IllegalArgumentException("Cannot add a null listener");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Cannot add a listener for a null class");
        }
        List<ObjectEditedListener> list = this.listenerListMap.get(clazz);
        if (list == null) {
            list = new ArrayList<ObjectEditedListener>();
            object = this.listenerListMap;
            synchronized (object) {
                if (!this.listenerListMap.containsKey(clazz)) {
                    this.listenerListMap.put(clazz, list);
                } else {
                    list = this.listenerListMap.get(clazz);
                }
            }
        }
        object = list;
        synchronized (object) {
            if (!list.contains(listener)) {
                list.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Class clazz, ObjectEditedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot remove a null listener");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Cannot remove a listener for a null class");
        }
        List<ObjectEditedListener> list = this.listenerListMap.get(clazz);
        if (list != null) {
            List<ObjectEditedListener> list2 = list;
            synchronized (list2) {
                list.remove(listener);
            }
        }
    }
}

