/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.gui;

import au.com.ordermate.gui.adminkit.ComponentColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.metal.MetalComboBoxUI;
import sun.swing.DefaultLookup;

public class WhiteComboBoxUI
extends MetalComboBoxUI {
    private JComboBox comboBox;

    public WhiteComboBoxUI(JComboBox comboBox) {
        this.comboBox = comboBox;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle b, boolean hasFocus) {
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = hasFocus && !this.isPopupVisible(this.comboBox) ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        c.setFont(this.comboBox.getFont());
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c.setForeground(this.listBox.getSelectionForeground());
            c.setBackground(ComponentColors.COMBO_BOX_EDITOR_COLOR);
            this.paintRectangleWithPadding(b, g);
        } else if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(ComponentColors.COMBO_BOX_EDITOR_COLOR);
        } else {
            c.setForeground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledForeground", null));
            c.setBackground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledBackground", null));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        int x = b.x;
        int y = b.y;
        int w = b.width;
        int h = b.height;
        if (this.padding != null) {
            w = b.width - (this.padding.left + this.padding.right);
            h = b.height - (this.padding.top + this.padding.bottom);
            x = b.x + this.padding.left;
            y = b.y + this.padding.top;
        }
        this.paintLocalValue(g, c, this.comboBox, x, y, w, h, shouldValidate);
    }

    private void paintRectangleWithPadding(Rectangle bounds, Graphics g) {
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        if (this.padding != null) {
            x = bounds.x + this.padding.left;
            y = bounds.y + this.padding.top;
            w = bounds.width - (this.padding.left + this.padding.right);
            h = bounds.height - (this.padding.top + this.padding.bottom);
        }
        this.paintRectangleWithColor(g, Color.LIGHT_GRAY, x, y, w, h);
    }

    private void paintRectangleWithColor(Graphics g, Color color, int x, int y, int w, int h) {
        Color oldColor = g.getColor();
        g.setColor(Color.BLACK);
        g.drawRect(x, y, w, h);
        g.setColor(oldColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintLocalValue(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
        if (c == null) {
            if (p != null) {
                this.paintRectangleWithColor(g, Color.BLACK, x, y, w, h);
            }
            return;
        }
        this.paintRectangleWithColor(g, Color.BLACK, x, y, w, h);
        c.setBounds(x, y, w, h);
        if (shouldValidate) {
            c.validate();
        }
        boolean wasDoubleBuffered = false;
        if (c instanceof JComponent && ((JComponent)c).isDoubleBuffered()) {
            wasDoubleBuffered = true;
            ((JComponent)c).setDoubleBuffered(false);
        }
        Graphics cg = g.create(x, y, w, h);
        try {
            c.paint(cg);
            cg.setColor(Color.GRAY);
            cg.drawRect(x, y, w - 1, h - 1);
        }
        finally {
            cg.dispose();
        }
        if (wasDoubleBuffered && c instanceof JComponent) {
            ((JComponent)c).setDoubleBuffered(true);
        }
        c.setBounds(-w, -h, 0, 0);
    }

    @Override
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        super.paintCurrentValueBackground(g, bounds, hasFocus);
        this.currentValuePane.setBackground(ComponentColors.COMBO_BOX_EDITOR_COLOR);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(ComponentColors.COMBO_BOX_EDITOR_COLOR);
        g2.fillRect(0, 0, bounds.width, bounds.height);
    }
}

