/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.gui.actions;

import au.com.ordermate.gui.actions.BasicAction;
import javax.swing.Icon;
import ordermate.database.users.Permission;
import ordermate.database.users.User;
import ordermate.signals.Signal;

public abstract class PermissibleAction
extends BasicAction {
    private Permission permission;
    private boolean securityEnabled = false;
    private boolean businessEnabled = true;

    public PermissibleAction(String name, Permission thePermission, Signal loginSignal, User currentUser) {
        super(name);
        this.setup(thePermission, loginSignal, currentUser);
    }

    public PermissibleAction(String name, Permission thePermission, Signal loginSignal, Icon icon, User currentUser) {
        super(name, icon);
        this.setup(thePermission, loginSignal, currentUser);
    }

    public PermissibleAction(String name, Permission thePermission, Signal loginSignal, Icon icon, String toolTip, User currentUser) {
        super(name, icon, toolTip);
        this.setup(thePermission, loginSignal, currentUser);
    }

    private void setup(Permission thePermission, Signal loginSignal, User currentUser) {
        this.permission = thePermission;
        if (this.permission != null) {
            loginSignal.connect(this, "secure");
            this.secure(currentUser);
        } else {
            this.securityEnabled = true;
        }
    }

    public void secure(User user) {
        if (this.permission == null) {
            this.securityEnabled = true;
            return;
        }
        if (user == null) {
            this.securityEnabled = false;
            this.updateEnabledState();
            return;
        }
        String accessLevel = user.getPermissionAccessLevel(this.permission);
        this.securityEnabled = accessLevel.equals("ENABLED");
        this.updateEnabledState();
    }

    @Override
    public void setEnabled(boolean enable) {
        this.businessEnabled = enable;
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        super.setEnabled(this.businessEnabled && this.securityEnabled);
    }
}

