/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.gui.adminkit;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import ca.odell.glazedlists.EventList;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import ordermate.gui.AutoCompletion;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXMonthView;

public class AdminGuiUtils {
    private static AdminGuiUtils instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void installGuiUtils(AdminGuiUtils utils) {
        if (utils == null) {
            throw new IllegalStateException("null passed in to installGuiUtils(), AdminGuiUtils.getInstance() cannot return null!");
        }
        if (instance != null) return;
        Class<AdminGuiUtils> clazz = AdminGuiUtils.class;
        synchronized (AdminGuiUtils.class) {
            if (instance != null) return;
            instance = utils;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static AdminGuiUtils getInstance() {
        if (instance == null) {
            throw new IllegalStateException("instance was not configured!, ensure the application performs ConfigureGuiUtilsTask before getInstance is called");
        }
        return instance;
    }

    public int selectIfPossible(JTable table, int row) {
        int rowActuallySelected = -1;
        int rowCount = table.getRowCount();
        if (rowCount > 0) {
            rowActuallySelected = row >= rowCount ? rowCount - 1 : (row < 0 ? 0 : row);
            table.setRowSelectionInterval(rowActuallySelected, rowActuallySelected);
        }
        return rowActuallySelected;
    }

    public void standardComboSetup(JComboBox combo) {
        int COMBO_ROW_COUNT = 20;
        AutoCompletion.enable(combo);
        combo.setPreferredSize(new Dimension(160, 20));
        combo.setMinimumSize(new Dimension(100, 20));
        combo.setMaximumRowCount(20);
        ComponentUtils.setupComboBox(combo);
    }

    public JXDatePicker standardDatePickerSetup(JXDatePicker datePicker) {
        DateFormat[] formats = new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")};
        datePicker.setFormats(formats);
        return datePicker;
    }

    public JXMonthView standardMonthViewSetup(JXMonthView monthView) {
        return monthView;
    }

    public void standardTreeSetup(JTree tree) {
        tree.toString();
    }

    public void standardSpinnerSetup(JSpinner spinner) {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)spinner.getEditor();
        final JFormattedTextField textField = editor.getTextField();
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textField.selectAll();
                    }
                });
            }
        });
    }

    public void standardListSetup(JList list) {
        list.toString();
    }

    public void refreshListWithCollection(EventList listToRefesh, Collection newData) {
        this.refreshList(listToRefesh, new ArrayList(newData));
    }

    public void refreshList(EventList listToRefresh, List newListData) {
        listToRefresh.retainAll((Collection)newListData);
        HashSet removeList = new HashSet(listToRefresh);
        Iterator it = removeList.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            int i = newListData.indexOf(obj);
            if (i == -1) continue;
            Object newObj = newListData.get(i);
            if (obj != newObj) {
                Collections.replaceAll(listToRefresh, obj, newObj);
            }
            it.remove();
        }
        listToRefresh.removeAll(removeList);
        Collection newElements = CollectionUtils.subtract((Collection)newListData, (Collection)listToRefresh);
        listToRefresh.addAll(newElements);
    }
}

