/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.gui.renderer;

import au.com.ordermate.util.Stringifier;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class JCheckBoxCellRenderer
extends JCheckBox
implements ListCellRenderer,
ActionListener,
ListSelectionListener {
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private ListCellRenderer decoratedRenderer = new DefaultListCellRenderer();
    private EventList selectedElements = new BasicEventList();
    private String noneText = "Any";
    private Stringifier stringFormat;

    public JCheckBoxCellRenderer(String newNoneText) {
        this();
        this.noneText = newNoneText;
    }

    public JCheckBoxCellRenderer() {
        this.setOpaque(true);
    }

    public void setDecoratedRenderer(DefaultListCellRenderer renderer) {
        this.decoratedRenderer = renderer;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.decoratedRenderer != null) {
            JLabel label = (JLabel)this.decoratedRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setText(label.getText());
            this.setBackground(label.getBackground());
            this.setForeground(label.getForeground());
        } else {
            this.setText(this.stringFormat != null ? this.stringFormat.stringify(value) : value.toString());
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        }
        this.setSelected(this.selectedElements.contains(value));
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = SAFE_NO_FOCUS_BORDER;
        }
        this.setBorder(border);
        return this;
    }

    public LinkedHashSet getSelectedElements() {
        return new LinkedHashSet(this.selectedElements);
    }

    public void setSelectedElements(Collection newSelected) {
        LinkedHashSet selection = new LinkedHashSet(newSelected);
        this.selectedElements.clear();
        this.selectedElements.addAll(selection);
    }

    protected void addSelectedElement(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Should not be trying to add null to selected items");
        }
        this.selectedElements.add(obj);
    }

    protected void removeSelectedElement(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Should not be trying to add null to selected items");
        }
        this.selectedElements.remove(obj);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComboBox) {
            final JComboBox source = (JComboBox)e.getSource();
            if (source.getRenderer() == this) {
                Object selectedObject = source.getSelectedItem();
                if (!this.comboBoxContainsElement(source, selectedObject)) {
                    return;
                }
                if (this.selectedElements.contains(selectedObject)) {
                    this.removeSelectedElement(selectedObject);
                } else {
                    this.addSelectedElement(selectedObject);
                }
            }
            source.setSelectedItem(this.getSelectedElementsString((Collection)this.selectedElements));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    source.setPopupVisible(true);
                }
            });
        }
    }

    public EventList getSelectionEventList() {
        return GlazedLists.readOnlyList((EventList)this.selectedElements);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object selectedObject;
        JList source;
        if (e.getSource() instanceof JList && !e.getValueIsAdjusting() && (source = (JList)e.getSource()).getCellRenderer() == this && (selectedObject = source.getSelectedValue()) != null) {
            if (this.selectedElements.contains(selectedObject)) {
                this.selectedElements.remove(selectedObject);
            } else {
                this.addSelectedElement(selectedObject);
            }
            source.clearSelection();
        }
    }

    public String getSelectedElementsString() {
        return this.getSelectedElementsString(this.getSelectedElements());
    }

    protected String getSelectedElementsString(Collection elements) {
        JList list = new JList();
        if (elements.isEmpty()) {
            return this.noneText;
        }
        String toReturn = " ";
        StringBuilder builder = null;
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            String text;
            if (builder == null) {
                builder = new StringBuilder();
                builder.append(toReturn);
            }
            Object elem = it.next();
            String string = text = this.stringFormat != null ? this.stringFormat.stringify(elem) : elem.toString();
            if (this.decoratedRenderer != null) {
                JLabel label = (JLabel)this.decoratedRenderer.getListCellRendererComponent(list, elem, 0, false, false);
                text = label.getText();
            }
            builder.append(text);
            if (!it.hasNext()) continue;
            builder.append(",");
        }
        if (builder != null) {
            toReturn = builder.toString();
        }
        return toReturn;
    }

    protected boolean comboBoxContainsElement(JComboBox box, Object element) {
        for (int i = 0; i < box.getItemCount(); ++i) {
            if (!element.equals(box.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    public static JCheckBoxCellRenderer install(JComboBox comboBox, String noneText) {
        JCheckBoxCellRenderer toInstall = new JCheckBoxCellRenderer(noneText);
        comboBox.setRenderer(toInstall);
        comboBox.addActionListener(toInstall);
        comboBox.setEditable(true);
        comboBox.setSelectedItem(noneText);
        JTextComponent editor = (JTextComponent)comboBox.getEditor().getEditorComponent();
        editor.setEditable(false);
        return toInstall;
    }

    public static JCheckBoxCellRenderer install(JList list) {
        JCheckBoxCellRenderer toInstall = new JCheckBoxCellRenderer();
        list.setCellRenderer(toInstall);
        list.setSelectionMode(0);
        list.addListSelectionListener(toInstall);
        return toInstall;
    }

    public void setStringFormat(Stringifier value) {
        this.stringFormat = value;
    }

    public void clearSelectedItems() {
        this.selectedElements.clear();
    }

    public String getNoneText() {
        return this.noneText;
    }
}

