/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.guicore;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public class TreeNodeSupport {
    private final PropertiedObject.Property parentProp;
    private final PropertiedObject.Property childrenProp;

    public TreeNodeSupport(PropertiedObject.Property parent, PropertiedObject.Property children) {
        this.parentProp = parent;
        this.childrenProp = children;
    }

    public Enumeration children(PersistentObject owner) {
        return Collections.enumeration(this.getChildren(owner));
    }

    private List getChildren(PersistentObject owner) {
        return (List)owner.getPropertyValue(this.childrenProp);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(PersistentObject owner, int childIndex) {
        List children = this.getChildren(owner);
        if (children.size() > childIndex && childIndex >= 0) {
            return (TreeNode)children.get(childIndex);
        }
        return null;
    }

    public int getChildCount(PersistentObject owner) {
        return this.getChildren(owner).size();
    }

    public int getIndex(PersistentObject owner, TreeNode node) {
        return this.getChildren(owner).indexOf(node);
    }

    public TreeNode getParent(PersistentObject owner) {
        return (TreeNode)owner.getPropertyValue(this.parentProp);
    }

    public boolean isLeaf(PersistentObject owner) {
        return this.getChildCount(owner) == 0;
    }

    public static List<? extends TreeNode> getAllChildren(TreeNode node) {
        if (node.isLeaf()) {
            return Collections.emptyList();
        }
        ArrayList<? extends TreeNode> returnList = new ArrayList<TreeNode>();
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode childNode = children.nextElement();
            returnList.add(childNode);
            returnList.addAll(TreeNodeSupport.getAllChildren(childNode));
        }
        return returnList;
    }

    public static boolean isChildOf(TreeNode thisNode, TreeNode potentialParent) {
        TreeNode group = thisNode;
        while (group.getParent() != null) {
            if (!(group = group.getParent()).equals(potentialParent)) continue;
            return true;
        }
        return false;
    }

    public static TreeNode getRoot(TreeNode node) {
        if (node.getParent() == null) {
            return node;
        }
        return TreeNodeSupport.getRoot(node.getParent());
    }
}

