/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.guicore.progress;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.progress.SplashProgressBar;
import au.com.ordermate.guicore.progress.StylisedButtonUI;
import au.com.ordermate.guicore.task.TaskInterrupter;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SplashPanel
extends JPanel {
    public static final int PANEL_WIDTH = 550;
    public static final int PANEL_HEIGHT = 480;
    protected SplashProgressBar progressBar;

    public SplashPanel(int numTasks) {
        this(numTasks, null);
    }

    public SplashPanel(int numTasks, TaskInterrupter newInterrupter) {
        this(numTasks, newInterrupter, null);
    }

    public SplashPanel(int numTasks, TaskInterrupter newInterrupter, BasicAction terminateAction) {
        super(new BorderLayout());
        this.setOpaque(false);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setPreferredSize(new Dimension(550, 480));
        panel.setLayout(new GraphPaperLayout(40, 40));
        if (newInterrupter != null) {
            final JButton skipTaskButton = this.createSkipTaskButton(newInterrupter);
            panel.add((Component)skipTaskButton, new Rectangle(25, 33, 12, 3));
            skipTaskButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    skipTaskButton.setVisible(false);
                }
            });
        }
        if (terminateAction != null) {
            panel.add((Component)this.createTerminateButton(terminateAction), new Rectangle(37, 1, 2, 2));
        }
        this.progressBar = new SplashProgressBar(0, numTasks);
        this.add((Component)panel, "Center");
        this.add((Component)this.progressBar, "South");
    }

    private JButton createTerminateButton(BasicAction terminateAction) {
        JButton terminateButton = new JButton(terminateAction);
        terminateButton.setRolloverIcon(IconLoader.get("/ordermate/images/exit_cross_hover.png"));
        terminateButton.setBackground(new Color(1, 1, 1));
        terminateButton.setBorderPainted(false);
        terminateButton.setBorder(null);
        terminateButton.setContentAreaFilled(false);
        terminateButton.setOpaque(false);
        return terminateButton;
    }

    private JButton createSkipTaskButton(TaskInterrupter newInterrupter) {
        final JButton skipTaskButton = new JButton(newInterrupter);
        StylisedButtonUI buttonUI = new StylisedButtonUI(new Color(180, 180, 180), Color.WHITE);
        buttonUI.installUI(skipTaskButton);
        skipTaskButton.setUI(buttonUI);
        skipTaskButton.setFont(skipTaskButton.getFont().deriveFont(13.0f));
        skipTaskButton.setForeground(Color.WHITE);
        skipTaskButton.setBackground(new Color(1, 1, 1));
        skipTaskButton.setBorderPainted(false);
        skipTaskButton.setBorder(null);
        skipTaskButton.setContentAreaFilled(false);
        skipTaskButton.setOpaque(false);
        skipTaskButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ((StylisedButtonUI)skipTaskButton.getUI()).setHover(true);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ((StylisedButtonUI)skipTaskButton.getUI()).setHover(false);
            }
        });
        return skipTaskButton;
    }

    public void setProgressMessage(String message) {
        this.progressBar.setString(message);
    }

    public void setProgressValue(int intValue) {
        this.progressBar.setValue(intValue);
    }

    public SplashProgressBar getProgressBar() {
        return this.progressBar;
    }
}

