/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.guicore.progress;

import au.com.ordermate.gui.adminkit.ComponentColors;
import au.com.ordermate.guicore.progress.SplashProgressBarUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JProgressBar;
import javax.swing.border.Border;

public class SplashProgressBar
extends JProgressBar {
    private boolean showingText = false;
    private SplashProgressBarUI theUi = new SplashProgressBarUI();

    public SplashProgressBar(int minimum, int maximum) {
        super(minimum, maximum);
        this.setUI(this.theUi);
        this.setBorder(null);
        this.setBorderPainted(false);
        this.setStringPainted(false);
        this.setPreferredSize(new Dimension(0, 5));
        this.setForeground(Color.WHITE);
        this.setBackground(ComponentColors.DARK_GRADIENT_END);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                SplashProgressBar.this.showingText = !SplashProgressBar.this.showingText;
                SplashProgressBar.this.setStringPainted(SplashProgressBar.this.showingText);
                SplashProgressBar.this.revalidate();
            }
        });
    }

    @Override
    public void updateUI() {
        this.setUI(this.theUi);
    }

    public void setShowingText(boolean value) {
        this.showingText = value;
        this.setStringPainted(this.showingText);
        this.revalidate();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(null);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (!this.showingText) {
            return new Dimension(size.width, 7);
        }
        return new Dimension(size.width, 30);
    }
}

