/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.guicore.progress;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class StylisedButtonUI
extends BasicButtonUI {
    private Color buttonColour;
    private Color hoverColour;
    private boolean isHovering;

    public StylisedButtonUI(Color staticColor, Color hoverColor) {
        this.buttonColour = staticColor;
        this.hoverColour = hoverColor;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Graphics2D g2 = (Graphics2D)g;
        AbstractButton button = (AbstractButton)c;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.5f));
        g2.setColor(this.isHovering ? this.hoverColour : this.buttonColour);
        int roundAmount = button.getHeight();
        g2.drawRoundRect(1, 1, button.getWidth() - 2, button.getHeight() - 2, roundAmount, roundAmount);
    }

    public void setHover(boolean hovering) {
        this.isHovering = hovering;
    }
}

