/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.guicore.progress;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.gui.adminkit.ComponentColors;
import au.com.ordermate.guicore.progress.SplashPanel;
import au.com.ordermate.guicore.progress.WindowFaderTarget;
import au.com.ordermate.guicore.task.TaskInterrupter;
import au.com.ordermate.util.FontManagerUtil;
import au.com.ordermate.util.image.IconLoader;
import com.sun.awt.AWTUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import ordermate.guicore.CopyrightInfo;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class VersionSplashWindow
extends JWindow {
    private static final String SYSTEM_FONT = "/utils/fonts/Poppins-Light.ttf";
    private String version;
    private String product;
    private SplashPanel splashPanel;

    public VersionSplashWindow(int numTasks, String versionString, String productString, TaskInterrupter newInterrupter, BasicAction terminateAction) {
        this.splashPanel = new VersionPanel(numTasks, newInterrupter, terminateAction);
        this.version = versionString;
        this.product = productString;
        this.add(this.splashPanel);
        if (AWTUtilities.isTranslucencyCapable((GraphicsConfiguration)this.getGraphicsConfiguration())) {
            AWTUtilities.setWindowOpaque((Window)this, (boolean)false);
            AWTUtilities.setWindowOpacity((Window)this, (float)0.0f);
        }
    }

    public SplashPanel getSplashPanel() {
        return this.splashPanel;
    }

    public VersionSplashWindow(int numTasks, String versionString, String productString) {
        this(numTasks, versionString, productString, null, null);
    }

    public VersionSplashWindow(int numTasks, String versionString, String productString, TaskInterrupter newInterrupter) {
        this(numTasks, versionString, productString, newInterrupter, null);
    }

    public void startSplashScreen() {
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.pack();
        this.setLocation((screenWidth - this.getWidth()) / 2, (screenHeight - this.getHeight()) / 2);
        if (AWTUtilities.isTranslucencyCapable((GraphicsConfiguration)this.getGraphicsConfiguration())) {
            WindowFaderTarget target = new WindowFaderTarget(this);
            Animator animator = new Animator(1000, (TimingTarget)target);
            animator.start();
        } else {
            this.setVisible(true);
            this.toFront();
        }
    }

    public void setProgress(Integer progress) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                new ProgressUpdater(progress).run();
            } else {
                SwingUtilities.invokeAndWait(new ProgressUpdater(progress));
            }
        }
        catch (Exception e) {
            OrderMateLog.LOG.error("Error setting progress bar progress", (Throwable)e);
        }
    }

    public void setMessage(String message) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                new MessageUpdater(message).run();
            } else {
                SwingUtilities.invokeAndWait(new MessageUpdater(message));
            }
        }
        catch (Exception e) {
            OrderMateLog.LOG.error("Error setting progress bar message", (Throwable)e);
        }
    }

    private final class VersionPanel
    extends SplashPanel {
        private static final int X_OFFSET = 35;
        private Font masterFont;
        private Font infoFont;
        private Font bigFont;
        private Image logo;

        private VersionPanel(int numTasks, TaskInterrupter interrupter, BasicAction terminateAction) {
            super(numTasks, interrupter, terminateAction);
            this.masterFont = FontManagerUtil.loadAndRegisterFont(VersionSplashWindow.SYSTEM_FONT, 16.0f);
            this.progressBar.setFont(this.masterFont);
            this.infoFont = this.masterFont.deriveFont(13.0f);
            this.bigFont = this.masterFont.deriveFont(17.0f);
            this.logo = IconLoader.getImage("/ordermate/images/logo_2024_transparent.png");
            double targetWidth = 220.0;
            double logoMultiplier = targetWidth / (double)this.logo.getWidth(null);
            int logoWidth = (int)((double)this.logo.getWidth(null) * logoMultiplier);
            int logoHeight = (int)((double)this.logo.getHeight(null) * logoMultiplier);
            this.logo = this.logo.getScaledInstance(logoWidth, logoHeight, 4);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            g.setColor(ComponentColors.COLOR_RED_BG);
            g.fillRect(0, 0, 550, 480);
            int xTopLeft = 357;
            int xBottomLeft = 220;
            int[] polyX = new int[]{xTopLeft, 550, 550, xBottomLeft};
            int[] polyY = new int[]{0, 0, 480, 480};
            Polygon gradedArea = new Polygon(polyX, polyY, 4);
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, ComponentColors.DARK_GRADIENT_START, 0.0f, 480.0f, ComponentColors.DARK_GRADIENT_END);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setPaint(gradient);
            g2d.fill(gradedArea);
            g.drawImage(this.logo, 23, 70, null);
            Color oldColor = g.getColor();
            g.setColor(Color.white);
            g.setFont(this.bigFont.deriveFont(2));
            int fontLength = g.getFontMetrics().stringWidth(VersionSplashWindow.this.version);
            g.drawString(VersionSplashWindow.this.version, 515 - fontLength, 115);
            g.setFont(this.bigFont);
            fontLength = g.getFontMetrics().stringWidth(VersionSplashWindow.this.product);
            g.drawString(VersionSplashWindow.this.product, 515 - fontLength, 90);
            g.setFont(this.infoFont);
            int initYOffset = 210;
            for (String copyrighttext : CopyrightInfo.getCopyrightLines()) {
                fontLength = g.getFontMetrics().stringWidth(copyrighttext);
                g.drawString(copyrighttext, 515 - fontLength, initYOffset);
                initYOffset += 18;
            }
            initYOffset = 210;
            for (String contacttext : CopyrightInfo.getContactLines()) {
                g.drawString(contacttext, 35, initYOffset);
                initYOffset += 18;
            }
            initYOffset = 270;
            for (String usagetext : CopyrightInfo.getUseLines()) {
                g.drawString(usagetext, 35, initYOffset);
                initYOffset += 20;
            }
            g.setColor(oldColor);
            super.paint(g);
        }
    }

    private class MessageUpdater
    implements Runnable {
        private String startupMessage;

        public MessageUpdater(String message) {
            this.startupMessage = message;
        }

        @Override
        public void run() {
            VersionSplashWindow.this.splashPanel.setProgressMessage(this.startupMessage);
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private Integer progress;

        public ProgressUpdater(Integer newProgress) {
            this.progress = newProgress;
        }

        @Override
        public void run() {
            VersionSplashWindow.this.splashPanel.setProgressValue(this.progress);
        }
    }
}

