/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.guicore.task;

import au.com.ordermate.guicore.task.Task;
import javax.swing.Icon;

public abstract class AbstractTask
extends Task {
    private boolean hasRun;
    private boolean runOnce = true;
    private PowerIncrementor incrementor = new PowerIncrementor();

    @Override
    public abstract String getName();

    @Override
    public int getProgressMaximum() {
        return this.getIncrementor().calcFastPower(this.getTotalSubTasks());
    }

    @Override
    public boolean hasMoreThanOneTask() {
        return this.getTotalSubTasks() > 1;
    }

    private PowerIncrementor getIncrementor() {
        return this.incrementor;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    protected abstract void performTask() throws Exception;

    @Override
    public final void run() {
        try {
            this.runLocal();
        }
        catch (RuntimeException e) {
            this.exceptionSignal.emit(e);
            throw e;
        }
        catch (Exception e) {
            this.exceptionSignal.emit(e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public final void runLocal() throws Exception {
        if (this.hasRun() && this.isRunOnce()) {
            throw new IllegalStateException("Tasks can only be run once");
        }
        this.performTask();
        this.done.emit();
        this.hasRun = true;
    }

    protected final void emitProgress() {
        int progressVal = this.getIncrementor().increment();
        this.clientProgress.emit(this.getName(), progressVal);
        this.progress.emit(progressVal);
    }

    public boolean hasRun() {
        return this.hasRun;
    }

    public boolean isRunOnce() {
        return this.runOnce;
    }

    public void setRunOnce(boolean newRunOnce) {
        this.runOnce = newRunOnce;
    }

    private static class PowerIncrementor {
        int rootValue = 1;

        PowerIncrementor() {
        }

        public int increment() {
            return this.calcFastPower(this.rootValue++);
        }

        protected int calcFastPower(int x) {
            int retVal = (int)Math.pow((double)x + (double)(1 - x) * 0.9, 2.0);
            return retVal;
        }
    }
}

