/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.guicore.task;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class CompositeTask
extends AbstractTask {
    public final Signal taskStarted = Signals.createSignal(String.class, "newTaskName");
    public static final Signal allTasksStarted = Signals.createSignal();
    private List<Task> subtasks = new Vector<Task>();
    private int totalSubTasks;
    private String name;
    private Icon icon;
    private int subTasksComplete;
    private String currentName;

    public CompositeTask(String newName) {
        this(newName, null);
    }

    public CompositeTask(String newName, Icon newIcon) {
        this.name = newName;
        this.icon = newIcon;
        this.currentName = null;
    }

    public void addTask(Task toAdd) {
        this.subtasks.add(toAdd);
        this.totalSubTasks += toAdd.getTotalSubTasks();
        toAdd.progress.connect(this, "gotProgress");
        toAdd.statusMessage.connect(this, "gotStatus");
        if (toAdd instanceof CompositeTask) {
            ((CompositeTask)toAdd).taskStarted.connect(this, "taskStarted");
        }
    }

    protected List<Task> getSubTasks() {
        return Collections.unmodifiableList(this.subtasks);
    }

    public void removeTask(Task toRemove) {
        if (this.subtasks.remove(toRemove)) {
            this.totalSubTasks -= toRemove.getTotalSubTasks();
            toRemove.progress.disconnect(this);
            toRemove.statusMessage.disconnect(this);
        } else {
            for (Task nextSub : this.subtasks) {
                if (!(nextSub instanceof CompositeTask)) continue;
                ((CompositeTask)nextSub).removeTask(toRemove);
            }
        }
    }

    @Override
    public int getTotalSubTasks() {
        return this.totalSubTasks;
    }

    @Override
    public String getName() {
        if (this.currentName != null) {
            return this.currentName;
        }
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void gotStatus(String msg) {
        this.sendStatus(msg);
    }

    public void taskStarted(String taskName) {
        this.currentName = taskName;
        this.taskStarted.emit(taskName);
    }

    @Override
    protected void performTask() throws Exception {
        Iterator<Task> it = this.subtasks.iterator();
        while (it.hasNext()) {
            AbstractTask subTask = (AbstractTask)it.next();
            this.taskStarted(subTask.getName());
            subTask.runLocal();
            this.subTasksComplete += subTask.getTotalSubTasks();
            it.remove();
        }
        allTasksStarted.emit();
    }

    public void gotProgress(Integer amount) {
        int progressAmount = this.subTasksComplete + amount;
        this.progress.emit(progressAmount);
    }
}

