/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.guicore.task;

import au.com.ordermate.guicore.task.Task;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public final class ProgressBarConnector {
    private JProgressBar progressBar;

    public static void connect(JProgressBar progressBar, Task task) {
        progressBar.setMaximum(task.getProgressMaximum());
        if (task.getTotalSubTasks() > 1) {
            ProgressBarConnector connector = new ProgressBarConnector(progressBar);
            task.progress.connect(connector, "setProgress");
        } else {
            progressBar.setIndeterminate(true);
            ProgressBarConnector connector = new ProgressBarConnector(progressBar);
            task.done.connect(connector, "stopProgress");
        }
    }

    private ProgressBarConnector(JProgressBar bar) {
        this.progressBar = bar;
    }

    public void setProgress(Integer progress) {
        int value = -1;
        if (progress != null) {
            value = progress;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setValue(value);
        } else {
            SwingUtilities.invokeLater(new ProgressUpdater(value));
        }
    }

    public void stopProgress() {
        if (SwingUtilities.isEventDispatchThread()) {
            new ProgressStopper().run();
        } else {
            SwingUtilities.invokeLater(new ProgressStopper());
        }
    }

    private final class ProgressStopper
    implements Runnable {
        private ProgressStopper() {
        }

        @Override
        public void run() {
            ProgressBarConnector.this.progressBar.setIndeterminate(false);
            ProgressBarConnector.this.progressBar.setValue(ProgressBarConnector.this.progressBar.getMaximum());
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private Integer progress;

        public ProgressUpdater(Integer newProgress) {
            this.progress = newProgress;
        }

        @Override
        public void run() {
            ProgressBarConnector.this.progressBar.setValue(this.progress);
        }
    }
}

