/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.integration.jaxb;

import au.com.ordermate.integration.jaxb.AbstractXMLIntegrationContext;
import au.com.ordermate.integration.jaxb.DefaultExportLaw;
import au.com.ordermate.integration.jaxb.ExportLaw;
import au.com.ordermate.integration.jaxb.Handler;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.ordermate.xmlintegration.entity.ExportEntityI;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import javax.xml.datatype.XMLGregorianCalendar;
import ordermate.jaxb.exporter.XMLHelper;

public abstract class AbstractHandler<T extends PersistentObject, E, OF>
implements Handler<T, E, OF> {
    private final AbstractXMLIntegrationContext<OF> integrationContext;
    private final Class<? extends T> domainClass;
    private final Class<E> elementClass;
    private String existingWhereClause = null;
    private ExportLaw exportLaw = DefaultExportLaw.getInstance();

    protected AbstractHandler(Class<? extends T> newDomainClass, Class<E> newElementClass, AbstractXMLIntegrationContext<OF> integrationContext) {
        this.domainClass = newDomainClass;
        this.elementClass = newElementClass;
        this.integrationContext = integrationContext;
    }

    public void setExistingWhereClause(String newWhereClause) {
        this.existingWhereClause = newWhereClause;
    }

    public void setExportLaw(ExportLaw theLaw) {
        this.exportLaw = theLaw;
        if (this.exportLaw == null) {
            this.exportLaw = DefaultExportLaw.getInstance();
        }
    }

    public ExportLaw getExportLaw() {
        return this.exportLaw;
    }

    public String getExistingWhereClause() {
        return this.existingWhereClause;
    }

    protected AbstractXMLIntegrationContext<OF> getIntegrationContext() {
        return this.integrationContext;
    }

    protected T getExistingOrCreateNew(ExportEntityI entity) throws UnmarshalException {
        return this.getExistingOrCreateNew(entity, this.integrationContext.getIDGenStrategy().getIDProperty(this.getDomainClass()));
    }

    protected T getExistingOrCreateNew(ExportEntityI entity, PropertiedObject.Property<? extends Number> idProp) throws UnmarshalException {
        T domainObj = this.getExisting(entity, idProp);
        if (domainObj == null) {
            domainObj = this.createDomainInstance(entity);
        }
        return domainObj;
    }

    protected T getExisting(ExportEntityI entity, PropertiedObject.Property<? extends Number> idProp) throws UnmarshalException {
        if (entity != null && entity.getID() != null) {
            ObjectQuery query = Query.select(this.getDomainClass()).equals(idProp, entity.getID());
            this.appendExistingWhereClause(query);
            return (T)((PersistentObject)this.integrationContext.getPersistenceDelegate().getObject(this.getDomainClass(), query.toString(), null, null));
        }
        return null;
    }

    protected Class<? extends T> determineConcreteType(E entity) {
        return this.getDomainClass();
    }

    protected T createDomainInstance(E entity) {
        try {
            Class<T> concreteType = this.determineConcreteType(entity);
            return (T)((PersistentObject)concreteType.newInstance());
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Should not happen with persistent objects of type : " + this.getDomainClass(), ex);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Should not happen with persistent objects of type : " + this.getDomainClass(), ie);
        }
    }

    @Override
    public final Class<? extends T> getDomainClass() {
        return this.domainClass;
    }

    @Override
    public final Class<E> getElementClass() {
        return this.elementClass;
    }

    protected Price convertToPrice(BigDecimal value) {
        return new Price(value.toString(), 0.01);
    }

    public <J extends PersistentObject, K> Handler<J, K, OF> getHandler(Class<J> domClass, Class<K> entClass) {
        Handler<J, K, OF> handler = this.getIntegrationContext().getHandler(domClass, entClass);
        if (this.existingWhereClause != null && handler instanceof AbstractHandler && ((AbstractHandler)handler).getExistingWhereClause() == null) {
            ((AbstractHandler)handler).setExistingWhereClause(this.existingWhereClause);
        }
        return handler;
    }

    protected XMLGregorianCalendar getDateTime(Date date) {
        return XMLHelper.getDateType(date);
    }

    protected <K> boolean addIfNotNull(List<K> entities, K entity) {
        if (entity != null) {
            entities.add(entity);
            return true;
        }
        return false;
    }

    protected <D extends PersistentObject, E> void exportList(List<E> targetExportList, List<D> toExport, Class<D> domainClass, Class<E> elementClass, OF objectFactory) {
        Handler<D, E, OF> handler = this.getIntegrationContext().getHandler(domainClass, elementClass);
        for (PersistentObject domainObj : toExport) {
            if (domainObj == null) continue;
            this.addIfNotNull(targetExportList, handler.exportDomainObject(domainObj, objectFactory));
        }
    }

    protected <D extends PersistentObject, F> F convertToExport(D toExport, Class<F> exportClass, OF objectFactory) {
        if (toExport == null) {
            return null;
        }
        Object toReturn = null;
        if (this.exportLaw.canExport(toExport, exportClass)) {
            toReturn = this.getIntegrationContext().getHandler(toExport.getClass(), exportClass).exportDomainObject(toExport, objectFactory);
            this.exportLaw.modify(toExport, exportClass, toReturn);
        }
        return toReturn;
    }

    protected SalesQuantity convertToSalesQuantity(BigDecimal decimal) {
        return new SalesQuantity(decimal);
    }

    public String toString() {
        return "AbstractHandler [domainClass=" + this.domainClass + ", elementClass=" + this.elementClass + "]";
    }

    protected <S extends PersistentObject> S importElement(Object element, Class<S> domClass) throws UnmarshalException {
        return this.importElement(element, domClass, null);
    }

    protected <S extends PersistentObject> S importElement(Object element, Class<S> domClass, PersistentObject parent) throws UnmarshalException {
        if (element == null) {
            return null;
        }
        Handler<S, ?, OF> handler = this.getIntegrationContext().getHandler(domClass, element.getClass());
        return handler.importElement(element, parent);
    }

    public ObjectQuery appendExistingWhereClause(ObjectQuery query) {
        if (this.existingWhereClause != null) {
            query.whereFunction(this.existingWhereClause);
        }
        return query;
    }
}

