/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.integration.jaxb;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.integration.jaxb.Handler;
import au.com.ordermate.persistence.PersistenceDelegate;
import au.com.ordermate.persistence.PersistentObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import ordermate.database.EventContext;
import ordermate.jaxb.exporter.handlers.online.idstrategy.IntegrationIDStrategy;

public abstract class AbstractXMLIntegrationContext<OF> {
    protected final Map<Key, Handler> handlerMap = new HashMap<Key, Handler>();
    private EventContext context;
    private IntegrationIDStrategy idGenStrategy;
    private final PersistenceDelegate persistence;
    private Map<Class, Object> currentObjectMap = new HashMap<Class, Object>();
    private Map<Class, Map<Long, ?>> objectMap = new HashMap();
    private Map<String, Object> attributeMap;
    private static long newObjectId = -1L;

    protected AbstractXMLIntegrationContext(IntegrationIDStrategy strategy, PersistenceDelegate delegate) {
        this.idGenStrategy = strategy;
        this.persistence = delegate;
    }

    public <T> Collection<T> getObjects(Class<T> clazzType) {
        if (this.objectMap.containsKey(clazzType)) {
            return this.objectMap.get(clazzType).values();
        }
        return Collections.emptySet();
    }

    public int sizeOf(Class clazzType) {
        if (this.objectMap.containsKey(clazzType)) {
            return this.objectMap.get(clazzType).size();
        }
        return 0;
    }

    public void clearObjects() {
        this.objectMap = new HashMap();
        this.attributeMap = new HashMap<String, Object>();
    }

    public <T extends PersistentObject> void addObjects(Class<T> clazzType, Collection<T> toAdd) {
        if (!this.objectMap.containsKey(clazzType)) {
            this.objectMap.put(clazzType, new LinkedHashMap());
        }
        Map<Long, ?> map = this.objectMap.get(clazzType);
        if (ExportableObject.class.isAssignableFrom(clazzType)) {
            for (PersistentObject nextT : toAdd) {
                Long id = this.idGenStrategy.getID((ExportableObject)((Object)nextT));
                if (map.containsKey(id)) continue;
                map.put(id, nextT);
            }
        } else {
            for (PersistentObject nextT : toAdd) {
                Long id = nextT.getID();
                map.put(id, nextT);
            }
        }
    }

    public <T extends PersistentObject> T addObject(Class<T> clazz, T value) {
        if (value == null) {
            return null;
        }
        if (!this.objectMap.containsKey(clazz)) {
            this.objectMap.put(clazz, new LinkedHashMap());
        }
        Map<Long, ?> map = this.objectMap.get(clazz);
        Long id = null;
        id = ExportableObject.class.isAssignableFrom(clazz) ? this.idGenStrategy.getID((ExportableObject)((Object)value)) : value.getID();
        if (id == null) {
            id = newObjectId;
            --newObjectId;
        }
        if (!map.containsKey(id)) {
            map.put(id, value);
        }
        return (T)((PersistentObject)map.get(id));
    }

    public <T> void removeObject(Class<T> clazz, T value) {
        if (this.objectMap.containsKey(clazz)) {
            this.objectMap.get(clazz).remove(value);
        }
    }

    public <T extends ExportableObject> boolean contains(Class<T> clazz, T value) {
        return this.objectMap.containsKey(clazz) && this.objectMap.get(clazz).containsKey(this.idGenStrategy.getID(value));
    }

    public IntegrationIDStrategy getIDGenStrategy() {
        return this.idGenStrategy;
    }

    public EventContext getEventContext() {
        return this.context;
    }

    public void setEventContext(EventContext ctx) {
        this.context = ctx;
    }

    public <T> T getCurrentObject(Class<T> clazz) {
        return (T)this.currentObjectMap.get(clazz);
    }

    public <T> void setCurrentObject(Class<? extends T> clazz, T value) {
        this.currentObjectMap.put(clazz, value);
    }

    public PersistenceDelegate getPersistenceDelegate() {
        return this.persistence;
    }

    public <T extends PersistentObject, E> Handler<T, E, OF> register(Handler<T, E, OF> handler) {
        this.handlerMap.put(new Key(handler.getDomainClass(), handler.getElementClass()), handler);
        return handler;
    }

    public Collection<Class<? extends PersistentObject>> getDomainClasses() {
        HashSet<Class<? extends PersistentObject>> classes = new HashSet<Class<? extends PersistentObject>>();
        for (Key key : this.handlerMap.keySet()) {
            classes.add(key.d);
        }
        return classes;
    }

    public Object getAttribute(String key) {
        if (this.attributeMap == null) {
            return null;
        }
        return this.attributeMap.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap<String, Object>();
        }
        this.attributeMap.put(key, value);
    }

    public <T extends PersistentObject, E> Handler<T, E, OF> getHandler(Class<? extends T> domainType, Class<E> exportEntityType) {
        Handler<? extends T, E, OF> handler = this.handlerMap.get(new Key(domainType, exportEntityType));
        if (handler == null) {
            handler = this.resolveHandler(domainType, exportEntityType);
        }
        return handler;
    }

    protected <T extends PersistentObject, E> Handler<T, E, OF> resolveHandler(Class<? extends T> domainType, Class<E> exportEntityType) {
        Class<T> domType = domainType;
        Handler handler = null;
        while (handler == null && !domType.equals(PersistentObject.class)) {
            Key key = new Key(domType, exportEntityType);
            handler = this.handlerMap.get(key);
            if (handler != null) {
                this.handlerMap.put(key, handler);
                return handler;
            }
            domType = domType.getSuperclass();
        }
        handler = this.doHandlerNotFound(domainType, exportEntityType);
        if (handler != null) {
            this.handlerMap.put(new Key(domainType, exportEntityType), handler);
        }
        return handler;
    }

    protected <T extends PersistentObject, E> Handler<T, E, OF> doHandlerNotFound(Class<? extends T> domainType, Class<E> exportEntityType) {
        throw new IllegalArgumentException("Handler is null for \ntype :" + domainType + "\nExportEntity : " + exportEntityType);
    }

    protected Collection<Handler> getHandlers() {
        return this.handlerMap.values();
    }

    private static class Key {
        private final Class d;
        private final Class e;

        public Key(Class domainClass, Class elementClass) {
            this.d = domainClass;
            this.e = elementClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.d == null ? 0 : this.d.hashCode());
            result = 31 * result + (this.e == null ? 0 : this.e.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.d == null ? other.d != null : !this.d.equals(other.d)) {
                return false;
            }
            return !(this.e == null ? other.e != null : !this.e.equals(other.e));
        }
    }
}

