/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.message;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.message.MessageServer;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Email {
    private List<Address> toRecipients;
    private List<InternetAddress> senders;
    private List<Address> replyTo;
    private List<Address> ccRecipients;
    private List<Address> bccRecipients;
    private List<File> attachFiles;
    private String subject;
    private String text;
    private MimeMultipart mimeMultipart;

    public Email() {
        this.init();
    }

    public Email(Message message) {
        if (message == null) {
            String s = "message cannot be null!";
            throw new IllegalArgumentException(s);
        }
        this.init();
        try {
            this.addToList(message.getRecipients(Message.RecipientType.TO), this.toRecipients);
            this.addToList(message.getFrom(), this.senders);
            this.addToList(message.getReplyTo(), this.replyTo);
            this.addToList(message.getRecipients(Message.RecipientType.CC), this.ccRecipients);
            this.addToList(message.getRecipients(Message.RecipientType.BCC), this.bccRecipients);
            this.setSubject(message.getSubject());
            Object content = message.getContent();
            if (content instanceof String) {
                this.setText((String)content);
            }
        }
        catch (Exception e) {
            String s = "Error creating Email from Message.";
            MessageServer.handleException(s, e);
        }
    }

    private void init() {
        this.toRecipients = new ArrayList<Address>();
        this.senders = new ArrayList<InternetAddress>();
        this.replyTo = new ArrayList<Address>();
        this.ccRecipients = new ArrayList<Address>();
        this.bccRecipients = new ArrayList<Address>();
        this.attachFiles = new ArrayList<File>();
    }

    private void addToList(Address[] addresses, List list) {
        if (addresses == null) {
            return;
        }
        for (int i = 0; i < addresses.length; ++i) {
            if (!(addresses[i] instanceof InternetAddress)) continue;
            list.add((InternetAddress)addresses[i]);
        }
    }

    public Message createMessage(Session session) {
        if (session == null) {
            String s = "session cannot be null!";
            throw new IllegalArgumentException(s);
        }
        MimeMessage message = new MimeMessage(session);
        try {
            Address[] addresses = this.toRecipients.toArray(new Address[this.toRecipients.size()]);
            message.setRecipients(Message.RecipientType.TO, addresses);
            addresses = this.replyTo.toArray(new Address[this.replyTo.size()]);
            message.setReplyTo(addresses);
            addresses = this.ccRecipients.toArray(new Address[this.ccRecipients.size()]);
            message.setRecipients(Message.RecipientType.CC, addresses);
            addresses = this.bccRecipients.toArray(new Address[this.bccRecipients.size()]);
            message.setRecipients(Message.RecipientType.BCC, addresses);
            if (this.subject != null) {
                message.setSubject(this.subject);
            } else {
                message.setSubject("");
            }
            MimeMultipart content = this.getPayload();
            if (this.mimeMultipart == null) {
                content = this.createBodyContent();
            }
            message.setContent((Multipart)content);
            if (this.senders.size() > 0) {
                message.setFrom((Address)this.senders.get(0));
            }
        }
        catch (MessagingException e) {
            String s = "Error creating Message from Email.";
            MessageServer.handleException(s, (Exception)((Object)e));
        }
        return message;
    }

    public MimeMultipart createBodyContent() throws MessagingException {
        MimeMultipart content = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        content.addBodyPart((BodyPart)textPart);
        if (this.text != null) {
            textPart.setText(this.text);
        } else {
            textPart.setText("");
        }
        for (File toAttach : this.attachFiles) {
            MimeBodyPart currentFilePart = new MimeBodyPart();
            FileDataSource dataSource = new FileDataSource(toAttach);
            currentFilePart.setDataHandler(new DataHandler((DataSource)dataSource));
            currentFilePart.setFileName(toAttach.getName());
            content.addBodyPart((BodyPart)currentFilePart);
        }
        return content;
    }

    public void addToRecipient(String email, String name) {
        try {
            this.addToRecipient(new InternetAddress(email, name));
        }
        catch (UnsupportedEncodingException e) {
            OrderMateLog.LOG.error("unexpected exception ", (Throwable)e);
        }
    }

    public void addToRecipient(InternetAddress address) {
        if (address != null) {
            this.toRecipients.add((Address)address);
        }
    }

    public InternetAddress[] getToRecipients() {
        return this.toRecipients.toArray(new InternetAddress[0]);
    }

    public void addSender(String email, String name) {
        try {
            this.addSender(new InternetAddress(email, name));
        }
        catch (UnsupportedEncodingException e) {
            OrderMateLog.LOG.error("unexpected exception ", (Throwable)e);
        }
    }

    public void addSender(InternetAddress address) {
        if (address != null) {
            this.senders.add(address);
        }
    }

    public InternetAddress[] getSenders() {
        return this.senders.toArray(new InternetAddress[0]);
    }

    public void addReplyTo(String email, String name) {
        try {
            this.replyTo.add((Address)new InternetAddress(email, name));
        }
        catch (UnsupportedEncodingException e) {
            OrderMateLog.LOG.error("unexpected exception ", (Throwable)e);
        }
    }

    public InternetAddress[] getReplyTo() {
        return this.replyTo.toArray(new InternetAddress[0]);
    }

    public void addCcRecipient(String email, String name) {
        try {
            this.ccRecipients.add((Address)new InternetAddress(email, name));
        }
        catch (UnsupportedEncodingException e) {
            OrderMateLog.LOG.error("unexpected exception ", (Throwable)e);
        }
    }

    public InternetAddress[] getCcRecipients() {
        return this.ccRecipients.toArray(new InternetAddress[0]);
    }

    public void addBccRecipient(String email, String name) {
        try {
            this.bccRecipients.add((Address)new InternetAddress(email, name));
        }
        catch (UnsupportedEncodingException e) {
            OrderMateLog.LOG.error("unexpected exception ", (Throwable)e);
        }
    }

    public InternetAddress[] getBccRecipients() {
        return this.bccRecipients.toArray(new InternetAddress[0]);
    }

    public void addAttachment(File toAdd) {
        if (!toAdd.isFile() || !toAdd.canRead()) {
            throw new IllegalArgumentException("Only valid, readable files can be attached to e-mails");
        }
        this.attachFiles.add(toAdd);
    }

    public File[] getAttachments() {
        return this.attachFiles.toArray(new File[0]);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String emailSubject) {
        this.subject = emailSubject;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String emailText) {
        this.text = emailText;
    }

    public void setPayload(MimeMultipart multiPart) {
        this.mimeMultipart = multiPart;
    }

    public MimeMultipart getPayload() {
        return this.mimeMultipart;
    }
}

