/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.message;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.message.Email;
import au.com.ordermate.message.Pop3ServerDetails;
import au.com.ordermate.message.SmtpServerDetails;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.util.StringUtils;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import ordermate.OrderMate;
import ordermate.database.message.MailServer;

public class MessageServer {
    private static final String KEY_SMTP_CONNECTION_TIMEOUT = "mail.smtp.connectiontimeout";
    private static final String VALUE_SMTP_CONNECTION_TIMEOUT = "10000";
    private static final String SMTP_TRANSPORT_SESSION = "smtp";
    private static final String POP3_TRANSPORT_SESSION = "pop3";
    private static MessageServer messageServer;
    private Session session;
    private Store store;
    private boolean smtpConnected;
    private SmtpServerDetails smtpServer;
    private Pop3ServerDetails pop3Server;

    private MessageServer() {
    }

    public boolean isSmtpServerConfigured() {
        SmtpServerDetails details = this.getSmtpServer();
        return !StringUtils.isEmpty(details.getHost()) && !StringUtils.isEmpty(details.getUsername()) && details.getPort() > 0;
    }

    public boolean isPopServerConfigured() {
        Pop3ServerDetails details = this.getPop3Server();
        return !StringUtils.isEmpty(details.getHost()) && !StringUtils.isEmpty(details.getUsername()) && !StringUtils.isEmpty(details.getPassword()) && details.getPort() > 0;
    }

    public synchronized void connectSmtp() {
        Properties props = System.getProperties();
        if (this.getSmtpServer() != null) {
            this.getSmtpServer().save(props);
        }
        if (this.getSmtpServer() != null && this.getSmtpServer().getMailAuthenticator() != null) {
            SmtpServerDetails.MailAuthenticator auth = this.getSmtpServer().getMailAuthenticator();
            this.session = Session.getInstance((Properties)props, (Authenticator)auth);
        } else {
            this.session = Session.getDefaultInstance((Properties)props);
        }
        if (!this.isSmtpConnected() && !this.connectSMTP()) {
            OrderMate.LOG.error("SMTP Server not connected!");
        }
    }

    public synchronized void connect() {
        Properties props = System.getProperties();
        if (this.getPop3Server() != null) {
            this.getPop3Server().save(props);
        }
        if (this.getSmtpServer() != null) {
            this.getSmtpServer().save(props);
        }
        if (this.getSmtpServer() != null && this.getSmtpServer().getMailAuthenticator() != null) {
            SmtpServerDetails.MailAuthenticator auth = this.getSmtpServer().getMailAuthenticator();
            this.session = Session.getInstance((Properties)props, (Authenticator)auth);
        } else {
            this.session = Session.getDefaultInstance((Properties)props);
        }
        if (!this.connectPop3()) {
            OrderMate.LOG.error("POP3 Server not connected!");
        }
        if (!this.isSmtpConnected() && !this.connectSMTP()) {
            OrderMate.LOG.error("SMTP Server not connected!");
        }
    }

    @Deprecated
    public synchronized void connectOld() {
        Properties props = System.getProperties();
        if (this.pop3Server != null) {
            this.pop3Server.save(props);
        }
        if (this.smtpServer != null) {
            this.smtpServer.save(props);
        }
        this.session = this.smtpServer != null && this.smtpServer.getMailAuthenticator() != null ? Session.getDefaultInstance((Properties)props, (Authenticator)this.smtpServer.getMailAuthenticator()) : Session.getDefaultInstance((Properties)props);
        try {
            this.store = this.session.getStore(POP3_TRANSPORT_SESSION);
            if (this.pop3Server != null) {
                this.store.connect(this.pop3Server.getHost(), this.pop3Server.getPort(), this.pop3Server.getUsername(), this.pop3Server.getPassword());
            } else {
                this.store.connect();
            }
        }
        catch (AuthenticationFailedException ex1) {
            OrderMateLog.LOG.info("POP3 server Authentication Failed.");
            OrderMateLog.LOG.debug((Object)ex1);
            this.store = null;
        }
        catch (MessagingException ex2) {
            MessageServer.handleException("Could not connect to POP3 server", (Exception)((Object)ex2));
            this.store = null;
        }
        try {
            this.session.getProperties().put(KEY_SMTP_CONNECTION_TIMEOUT, VALUE_SMTP_CONNECTION_TIMEOUT);
            Transport transport = this.session.getTransport(SMTP_TRANSPORT_SESSION);
            transport.addConnectionListener((ConnectionListener)new SmtpConnectionListener());
            transport.addTransportListener((TransportListener)new SmtpTransportListener());
            if (this.smtpServer != null) {
                transport.connect(this.smtpServer.getHost(), this.smtpServer.getPort(), this.smtpServer.getUsername(), this.smtpServer.getPassword());
            } else {
                transport.connect();
            }
            this.smtpConnected = true;
        }
        catch (AuthenticationFailedException ex1) {
            OrderMateLog.LOG.info("SMTP server Authentication Failed.");
            OrderMateLog.LOG.debug((Object)ex1);
            this.smtpConnected = false;
        }
        catch (MessagingException ex2) {
            MessageServer.handleException("Could not connect to SMTP server. SMTP server is not available...", (Exception)((Object)ex2));
            this.smtpConnected = false;
        }
    }

    public boolean isConnected() {
        return this.isSmtpConnected() && this.isPop3Connected();
    }

    public boolean isSmtpConnected() {
        return this.smtpConnected;
    }

    public boolean isPop3Connected() {
        return this.store != null && this.store.isConnected();
    }

    public synchronized Folder openFolder(String folderName) {
        if (folderName == null) {
            String s = "folderName cannot be null!";
            throw new IllegalArgumentException(s);
        }
        try {
            if (this.connectPop3()) {
                Folder folder = this.store.getFolder(folderName);
                return folder;
            }
        }
        catch (MessagingException e) {
            MessageServer.handleException("Could not receive emails", (Exception)((Object)e));
        }
        return null;
    }

    public synchronized Email[] receiveMails(String folderName) {
        Folder folder = this.openFolder(folderName);
        if (folder != null) {
            return this.receiveMails(folder);
        }
        return null;
    }

    private Email[] receiveMails(Folder folder) {
        block9: {
            if (folder == null) {
                String s = "folder cannot be null!";
                throw new IllegalArgumentException(s);
            }
            try {
                if (!this.isPop3Connected()) break block9;
                try {
                    if (!folder.isOpen()) {
                        folder.open(2);
                    }
                }
                catch (MethodNotSupportedException e) {
                    String s = "Could not open POP3 folder for read/write.";
                    MessageServer.handleException(s, (Exception)((Object)e));
                }
                Message[] messages = folder.getMessages();
                FetchProfile fp = new FetchProfile();
                fp.add(FetchProfile.Item.ENVELOPE);
                fp.add(FetchProfile.Item.FLAGS);
                fp.add("X-Mailer");
                folder.fetch(messages, fp);
                Email[] emails = new Email[messages.length];
                for (int i = 0; i < emails.length; ++i) {
                    emails[i] = new Email(messages[i]);
                }
                folder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
                try {
                    folder.close(true);
                }
                catch (MethodNotSupportedException e) {
                    String s = "Could not close POP3 folder.";
                    MessageServer.handleException(s, (Exception)((Object)e));
                }
                return emails;
            }
            catch (MessagingException e) {
                String s = "Error receiving emails.";
                MessageServer.handleException(s, (Exception)((Object)e));
            }
        }
        return new Email[0];
    }

    public synchronized boolean send(Message message) {
        int NUM_RETRIES = 5;
        if (message == null) {
            String s = "message cannot be null!";
            throw new IllegalArgumentException(s);
        }
        for (int i = 0; i < 5; ++i) {
            try {
                if (i > 0) {
                    OrderMateLog.LOG.info("Retrying to send message");
                }
                if (!this.isSmtpConnected()) {
                    OrderMate.LOG.info("SMTP is not connected, attempting to reconnect");
                    this.connectSMTP();
                }
                if (!this.isSmtpConnected()) continue;
                Transport.send((Message)message);
                OrderMate.LOG.info("Transport successfully sent message");
                return true;
            }
            catch (AuthenticationFailedException ex1) {
                OrderMateLog.LOG.info("SMTP server Authentication Failed.");
                OrderMateLog.LOG.debug((Object)ex1);
                continue;
            }
            catch (MessagingException e) {
                String s = "Error sending emails.";
                MessageServer.handleException(s, (Exception)((Object)e));
            }
        }
        return false;
    }

    public Session getSession() {
        return this.session;
    }

    private SmtpServerDetails getSmtpServer() {
        if (this.smtpServer == null) {
            this.smtpServer = this.getSmtpDetailsFromDB();
        }
        return this.smtpServer;
    }

    private Pop3ServerDetails getPop3Server() {
        if (this.pop3Server == null) {
            this.pop3Server = this.getPop3DetailsFromDB();
        }
        return this.pop3Server;
    }

    public synchronized void serversChanged() {
        this.smtpConnected = false;
        this.session = null;
        CacheManager.getInstance().clearCache(MailServer.class);
        this.smtpServer = null;
        this.pop3Server = null;
    }

    static void handleException(String message, Exception e) {
        OrderMateLog.LOG.info(message, (Throwable)e);
    }

    public static MessageServer getServer() {
        if (messageServer == null) {
            messageServer = new MessageServer();
        }
        return messageServer;
    }

    public static void setMessageServer(MessageServer server) {
        messageServer = server;
    }

    private boolean connectPop3() {
        if (this.isPop3Connected()) {
            return true;
        }
        try {
            this.store = this.session.getStore(POP3_TRANSPORT_SESSION);
            if (this.getPop3Server() != null) {
                this.store.connect(this.getPop3Server().getHost(), this.getPop3Server().getPort(), this.getPop3Server().getUsername(), this.getPop3Server().getPassword());
            } else {
                this.store.connect();
            }
            OrderMate.LOG.info("POP 3 server '" + this.getPop3Server().getHost() + "' successfully connected...");
            return true;
        }
        catch (AuthenticationFailedException ex1) {
            OrderMateLog.LOG.info("POP3 server Authentication Failed.");
            OrderMateLog.LOG.debug((Object)ex1);
            this.store = null;
            return false;
        }
        catch (MessagingException ex2) {
            MessageServer.handleException("Could not connect to POP3 server", (Exception)((Object)ex2));
            this.store = null;
            return false;
        }
    }

    private boolean connectSMTP() {
        try {
            this.session.getProperties().put(KEY_SMTP_CONNECTION_TIMEOUT, VALUE_SMTP_CONNECTION_TIMEOUT);
            Transport transport = this.session.getTransport(SMTP_TRANSPORT_SESSION);
            transport.addConnectionListener((ConnectionListener)new SmtpConnectionListener());
            transport.addTransportListener((TransportListener)new SmtpTransportListener());
            if (this.getSmtpServer() != null) {
                OrderMate.LOG.info("Connecting to SMTP Server:" + this.getSmtpServer().getHost() + " " + this.getSmtpServer().getPort() + " " + this.getSmtpServer().getUsername());
                transport.connect(this.getSmtpServer().getHost(), this.getSmtpServer().getPort(), this.getSmtpServer().getUsername(), this.getSmtpServer().getPassword());
            } else {
                OrderMate.LOG.info("No SMTP Server configured");
                transport.connect();
            }
            this.smtpConnected = transport.isConnected();
            OrderMate.LOG.info("SMTP server '" + this.getSmtpServer().getHost() + "' successfully connected...");
            return true;
        }
        catch (AuthenticationFailedException ex1) {
            OrderMateLog.LOG.info("SMTP server Authentication Failed.", (Throwable)ex1);
            this.smtpConnected = false;
            return false;
        }
        catch (MessagingException ex2) {
            MessageServer.handleException("Could not connect to SMTP server. SMTP server is not available...", (Exception)((Object)ex2));
            this.smtpConnected = false;
            return false;
        }
    }

    private Pop3ServerDetails getPop3DetailsFromDB() {
        MailServer serverPop3 = MailServer.getMailServer("POP3");
        return new Pop3ServerDetails(serverPop3.getHost(), serverPop3.getPort(), serverPop3.isSslConnection(), serverPop3.isTlsConnection(), serverPop3.getUsername(), serverPop3.getPasswordRaw());
    }

    private SmtpServerDetails getSmtpDetailsFromDB() {
        MailServer serverSmtp = MailServer.getMailServer("SMTP");
        return new SmtpServerDetails(serverSmtp.getHost(), serverSmtp.getPort(), serverSmtp.isSslConnection(), serverSmtp.isTlsConnection(), serverSmtp.getUsername(), serverSmtp.getPasswordRaw());
    }

    private static final class SmtpTransportListener
    implements TransportListener {
        private SmtpTransportListener() {
        }

        public void messageDelivered(TransportEvent arg0) {
            OrderMate.LOG.info("e-mail message delivered over the SMTP connection...");
        }

        public void messageNotDelivered(TransportEvent arg0) {
            OrderMate.LOG.info("e-mail message could NOT be delivered over the SMTP connection...");
        }

        public void messagePartiallyDelivered(TransportEvent arg0) {
            OrderMate.LOG.info("e-mail message could only be delivered partially over the SMTP connection...");
        }
    }

    private final class SmtpConnectionListener
    implements ConnectionListener {
        private SmtpConnectionListener() {
        }

        public void closed(ConnectionEvent arg0) {
            MessageServer.this.smtpConnected = false;
            OrderMateLog.LOG.info("SMTP Server connection closed...");
        }

        public void disconnected(ConnectionEvent arg0) {
            MessageServer.this.smtpConnected = false;
            OrderMateLog.LOG.info("SMTP Server disconnected...");
        }

        public void opened(ConnectionEvent arg0) {
            MessageServer.this.smtpConnected = true;
            OrderMateLog.LOG.info("SMTP Server successfully connected...");
        }
    }
}

