/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.message;

import au.com.ordermate.OrderMateLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.message.SmsProvider;
import ordermate.database.users.User;

public class SMS {
    List<String> placeholderParams = Arrays.asList("%0n", "%0m", "%1", "%2", "%3", "%4", "%5");
    private String phoneNumber;
    private String text;
    private static String EMAIL_SUFFIX;
    private static String SUBJECT;
    private static InternetAddress SENDER_ADDRESS;
    private String lastHTTPError = "";

    public Message createMessage(Session session) {
        if (!SMS.isSetup()) {
            String s = "setup() must be called before creating Messages!";
            throw new IllegalStateException(s);
        }
        if (session == null) {
            String s = "session cannot be null!";
            throw new IllegalArgumentException(s);
        }
        MimeMessage message = new MimeMessage(session);
        try {
            InternetAddress address = new InternetAddress(this.phoneNumber + EMAIL_SUFFIX);
            message.setRecipient(Message.RecipientType.TO, (Address)address);
            message.setSubject(SUBJECT);
            message.setFrom((Address)SENDER_ADDRESS);
            message.setText(this.text);
        }
        catch (Exception e) {
            String s = "Setup of message failed";
            OrderMateLog.LOG.error(s, (Throwable)e);
        }
        return message;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String thePhoneNumber) {
        this.phoneNumber = thePhoneNumber;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String theText) {
        this.text = theText;
    }

    public void logSend() {
        this.logSend(null);
    }

    public void logSend(User sender) {
        String timestamp = "";
        Calendar cal = Calendar.getInstance();
        timestamp = timestamp + this.pad(cal.get(1));
        timestamp = timestamp + this.pad(cal.get(2) + 1);
        timestamp = timestamp + this.pad(cal.get(5));
        timestamp = timestamp + this.pad(cal.get(11));
        timestamp = timestamp + this.pad(cal.get(12));
        timestamp = timestamp + this.pad(cal.get(13));
        try {
            Data.database.logSmsSend(timestamp, this.phoneNumber, this.text, sender);
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    public static void setup(String emailSuffix, String subject, String senderEmail, String senderName) {
        EMAIL_SUFFIX = emailSuffix.startsWith("@") ? emailSuffix : "@" + emailSuffix;
        SUBJECT = subject;
        try {
            SENDER_ADDRESS = new InternetAddress(senderEmail, senderName);
        }
        catch (UnsupportedEncodingException e) {
            String s = "Error setting up sender's address";
            OrderMateLog.LOG.error(s, (Throwable)e);
        }
    }

    public static boolean isSetup() {
        return EMAIL_SUFFIX != null && SUBJECT != null && SENDER_ADDRESS != null;
    }

    private String pad(int i) {
        if (i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    private SmsProvider getSmsProviderSettings() {
        SmsProvider provider = SmsProvider.getProvider();
        return provider;
    }

    public boolean sendSMSviaHTTP(boolean checkResult) {
        boolean result = true;
        try {
            String line;
            SmsProvider settings = this.getSmsProviderSettings();
            if (settings == null || settings.getUrl().equals("") || settings.getProviderType() == null || settings.getProviderType().equals((Object)SmsProvider.SMSProviderType.Email)) {
                OrderMate.LOG.error("Error in the sms provider settings... check table 'config_sms_provider'!");
                return false;
            }
            URL url = new URL(this.getBaseURL(settings.getUrl()));
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(this.getPlaceHolderValues(this.getPlaceHolderSequence(settings.getUrl()), settings, this.getValidatedPhoneNumber(this.phoneNumber), this.text));
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                OrderMate.LOG.info("SMS over HTTP - Server answer: " + line);
            }
            wr.close();
            rd.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return result;
    }

    private String getBaseURL(String baseURL) {
        if (baseURL.contains("%")) {
            int cut = baseURL.indexOf("%");
            return baseURL.substring(0, cut);
        }
        return baseURL;
    }

    private String getPlaceHolderSequence(String baseURL) {
        if (baseURL.contains("%")) {
            int cut = baseURL.indexOf("%");
            return baseURL.substring(cut);
        }
        return "";
    }

    private String getPlaceHolderValues(String placeholders, SmsProvider settings, String number, String message) {
        String toReturn = placeholders;
        for (String current : this.placeholderParams) {
            toReturn = toReturn.replaceAll(current, this.getValueFor(current, settings, number, message));
        }
        return toReturn;
    }

    private String getValueFor(String placeholder, SmsProvider settings, String number, String message) {
        if (placeholder.equals("%0n")) {
            return settings.getPlaceholderNumberKey() + "=" + number;
        }
        if (placeholder.equals("%0m")) {
            return settings.getPlaceholderMessageKey() + "=" + message;
        }
        if (placeholder.equals("%1")) {
            return settings.getPlaceholder1Key() + "=" + settings.getPlaceholder1Value();
        }
        if (placeholder.equals("%2")) {
            return settings.getPlaceholder2Key() + "=" + settings.getPlaceholder2Value();
        }
        if (placeholder.equals("%3")) {
            return settings.getPlaceholder3Key() + "=" + settings.getPlaceholder3Value();
        }
        if (placeholder.equals("%4")) {
            return settings.getPlaceholder4Key() + "=" + settings.getPlaceholder4Value();
        }
        if (placeholder.equals("%5")) {
            return settings.getPlaceholder5Key() + "=" + settings.getPlaceholder5Value();
        }
        return "";
    }

    protected boolean isResultValid(int result) {
        switch (result) {
            case 0: {
                return true;
            }
            case 11: {
                return true;
            }
        }
        return false;
    }

    public String getLastHTTPErrorMessage() {
        return this.lastHTTPError;
    }

    public String getValidatedPhoneNumber(String phoneNr) {
        String prefix = this.getSmsProviderSettings().getPrefixValidated();
        if (!prefix.equals("")) {
            String numberToReturn = prefix;
            for (int i = 0; i < phoneNr.length(); ++i) {
                char digit = phoneNr.charAt(i);
                if (i <= 0 && digit == '0') continue;
                numberToReturn = numberToReturn + digit;
            }
            return numberToReturn;
        }
        return phoneNr;
    }
}

