/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.message;

import au.com.ordermate.message.ServerDetails;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;

public class SmtpServerDetails
extends ServerDetails {
    private final Integer CONNECTION_TIMEOUT = 10000;
    private final Integer READ_WRITE_TIMEOUT = 10000;
    private MailAuthenticator authenticator;

    public SmtpServerDetails(String theHost, int thePort, boolean isSSL, boolean isTSL, String theUsername, String thePassword) {
        super(theHost, thePort, isSSL, isTSL, theUsername, thePassword);
    }

    @Override
    public void save(Properties props) {
        if (props == null) {
            return;
        }
        props.setProperty("mail.smtp.host", this.host);
        props.setProperty("mail.smtp.port", String.valueOf(this.port));
        if (this.isSsl()) {
            props.put("mail.smtp.socketFactory.port", String.valueOf(this.port));
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.starttls.enable", "false");
        } else if (this.isTls()) {
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.ssl.trust", "*");
            props.put("mail.smtp.socketFactory.class", "");
        } else {
            props.put("mail.smtp.auth", "false");
            props.put("mail.smtp.socketFactory.class", "");
            props.put("mail.smtp.starttls.enable", "false");
        }
        props.put("mail.smtp.connectiontimeout", this.CONNECTION_TIMEOUT);
        props.put("mail.smtp.timeout", this.READ_WRITE_TIMEOUT);
    }

    public MailAuthenticator getMailAuthenticator() {
        if (this.authenticator == null) {
            this.authenticator = new MailAuthenticator(this.getUsername(), this.getPassword());
        }
        return this.authenticator;
    }

    private static class MailAuthenticator
    extends Authenticator {
        String user;
        String pass;

        public MailAuthenticator(String username, String password) {
            this.user = username;
            this.pass = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.pass);
        }
    }
}

