/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio;

import au.com.ordermate.networkio.ExecuteTaskAsLocalService;
import au.com.ordermate.persistence.Executable;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import ordermate.OrderMate;
import sun.awt.AppContext;

public class ExecuteTaskAsLocalServiceImpl
extends UnicastRemoteObject
implements ExecuteTaskAsLocalService,
Serializable {
    private ThreadGroup mainGroup = AppContext.getAppContext().getThreadGroup();

    @Override
    public <T> T executeTaskWithResult(Executable<T> executable) throws RemoteException {
        this.init();
        this.runThread(executable);
        return executable.getReturnValue();
    }

    @Override
    public <T> void executeTask(Executable<T> executable) throws RemoteException {
        this.init();
        this.runThread(executable);
    }

    @Override
    public <T> void executeTaskAsync(final Executable<T> executable) throws RemoteException {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ExecuteTaskAsLocalServiceImpl.this.init();
                executable.execute();
            }
        };
        new Thread(this.mainGroup, r).start();
    }

    private <T> void runThread(final Executable<T> executable) {
        Thread thread = new Thread(this.mainGroup, new Runnable(){

            @Override
            public void run() {
                if (AppContext.getAppContext() == null) {
                    OrderMate.LOG.info("AppContext is null at this point");
                } else {
                    OrderMate.LOG.info("AppContext is not null");
                }
                executable.execute();
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            OrderMate.LOG.info("Interrupted while running asLocal Executable", (Throwable)ex);
        }
    }

    private void init() {
    }
}

