/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio;

import au.com.ordermate.networkio.NotificationDetails;
import au.com.ordermate.networkio.RemoteIO;
import au.com.ordermate.networkio.RemoteIOImpl;
import au.com.ordermate.networkio.ports.OutputPort;
import au.com.ordermate.simplermi.SimpleRMI;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import ordermate.OrderMate;

public class NetworkIO {
    private static RemoteIO localServer;

    public static void startServer(OutputPort output) throws Exception {
        NetworkIO.startServer(output, null);
    }

    public static void startServer(OutputPort output, String logPrefix) throws Exception {
        if (localServer == null) {
            localServer = (RemoteIO)SimpleRMI.shareObject(new RemoteIOImpl(), "NetworkIOService");
        }
        localServer.startQueue(output, logPrefix);
    }

    public static OutputPort getPort(String portName) {
        if (localServer == null) {
            return null;
        }
        try {
            return localServer.getPort(portName);
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot get port from remote RemoteIO implementation", (Throwable)ex);
            return null;
        }
    }

    public static boolean hasServer(String portName) {
        if (localServer == null) {
            return false;
        }
        try {
            return localServer.hasQueue(portName);
        }
        catch (RemoteException ex) {
            OrderMate.LOG.error("Cannot call has Server from remote RemoteIO implementation;", (Throwable)ex);
            return false;
        }
    }

    public static void shutdown() {
        if (localServer != null) {
            try {
                localServer.shutdown();
            }
            catch (RemoteException ex) {
                OrderMate.LOG.error("Cannot call shutdown from remote RemoteIO implementation", (Throwable)ex);
            }
            SimpleRMI.unshareObject("NetworkIOService");
            localServer = null;
        }
    }

    public static void sendData(String data, String port, int serverPort, InetAddress hostAddress, String description) throws IOException, IllegalStateException {
        if (hostAddress.equals(InetAddress.getLocalHost()) && serverPort == SimpleRMI.getSharePort()) {
            localServer.queueData(data, port, description);
        } else {
            try {
                RemoteIO remote = (RemoteIO)SimpleRMI.getObject(hostAddress, "NetworkIOService", serverPort);
                remote.queueData(data, port, description);
            }
            catch (NotBoundException e) {
                IllegalStateException ise = new IllegalStateException("startServer() must be called for host " + hostAddress + ":" + serverPort);
                ise.initCause(e);
                throw ise;
            }
        }
    }

    public static void sendData(String data, String port, int serverPort, InetAddress hostAddress, String description, NotificationDetails details) throws IOException, IllegalStateException {
        if (hostAddress.equals(InetAddress.getLocalHost()) && serverPort == SimpleRMI.getSharePort()) {
            localServer.queueData(data, port, description, details);
        } else {
            try {
                RemoteIO remote = (RemoteIO)SimpleRMI.getObject(hostAddress, "NetworkIOService", serverPort);
                remote.queueData(data, port, description, details);
            }
            catch (NotBoundException e) {
                IllegalStateException ise = new IllegalStateException("startServer() must be called for host " + hostAddress + ":" + serverPort);
                ise.initCause(e);
                throw ise;
            }
        }
    }
}

