/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.networkio.IONotification;
import au.com.ordermate.networkio.NotificationDetails;
import au.com.ordermate.networkio.ports.OutputPort;
import au.com.ordermate.simplermi.SimpleRMI;
import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Logger;

public class PortQueue
implements Runnable {
    private static final int MAX_NUM_RETRIES_NORMAL = 3;
    private static final int MAX_NUM_RETRIES_ERROR = 1;
    private static final int NORMAL_MODE = 0;
    private static final int ERROR_MODE = 1;
    private int num_retries;
    private int mode;
    private BlockingQueue<PortData> toPrint = new LinkedBlockingQueue<PortData>();
    private boolean stop;
    private OutputPort port;
    private boolean logging = false;
    private Logger queueLog;
    private Exception lastException;

    private String getParentLoggingFolder() {
        return System.getProperty("log.root") + "Printing" + File.separator + "Ports" + File.separator;
    }

    public PortQueue(OutputPort newPort, String logPrefix) throws Exception {
        this.port = newPort;
        this.mode = 0;
        this.num_retries = 3;
        newPort.openConnection();
        if (logPrefix != null) {
            this.setLogging(true);
            String queueLogName = newPort.getName() + "-thread";
            Logger configureQueueLog = OrderMateLog.createLogger(this.getParentLoggingFolder(), queueLogName);
            configureQueueLog.setAdditive(false);
            String safeName = newPort.getName().replaceAll("[^a-zA-Z0-9]", "");
            String logName = "Port-" + safeName + "-thread";
            this.queueLog = OrderMateLog.createLogger(this.getParentLoggingFolder(), logName);
            this.queueLog.setAdditive(false);
        } else {
            this.setLogging(false);
        }
        Thread queueThread = new Thread((Runnable)this, "PortQueue" + this.port.getName());
        queueThread.start();
    }

    public void add(String data, String description, NotificationDetails details) {
        PortData portData = new PortData(data, description, details);
        if (data == null) {
            OrderMateLog.LOG.warn("Avoid putting null data in port queue, data was null for " + description);
            portData.complete();
            return;
        }
        this.toPrint.add(portData);
        this.log("Added data '" + portData + "' to print queue (Queue size now " + this.toPrint.size() + ")");
    }

    public synchronized OutputPort getPort() {
        return this.port;
    }

    public synchronized int getSize() {
        return this.toPrint.size();
    }

    @Override
    public void run() {
        this.log("Starting up PortQueue thread");
        while (!this.stop) {
            try {
                boolean success;
                PortData job;
                try {
                    job = this.toPrint.poll(this.port.getAutoShutdownTime(), TimeUnit.MILLISECONDS);
                    if (this.stop) {
                        this.log("Shutting down PortQueue thread");
                        this.closeConnection();
                        return;
                    }
                    if (job == null) {
                        this.log("No dockets in queue, waiting");
                        this.closeConnection();
                        job = this.toPrint.take();
                    }
                }
                catch (InterruptedException e) {
                    this.log("Interrupted while waiting for docket, Shutting down port queue!", e);
                    return;
                }
                if (this.stop) {
                    this.log("Shutting down PortQueue thread");
                    this.closeConnection();
                    return;
                }
                this.log("Got data for printing out of queue '" + job + "' (Queue size now aprox" + this.toPrint.size() + ")");
                this.log("Starting to send '" + job + "'");
                job.connectNotification();
                job.started();
                if (this.mode == 0) {
                    success = this.sendNormalMode(job);
                } else {
                    this.sendErrorMode(this.port.getErrorCommandString(), "Discard last job");
                    success = this.sendErrorMode(job.getData(), job.getDescription());
                }
                this.messageDone(job.toString());
                if (success &= this.messageDone(job.toString())) {
                    this.mode = 0;
                    this.num_retries = 3;
                    job.complete();
                    this.log("Done sending '" + job + "'");
                    continue;
                }
                if (this.mode != 1) {
                    this.mode = 1;
                    this.num_retries = 1;
                    ArrayList errorJobs = new ArrayList();
                    this.toPrint.drainTo(errorJobs);
                    for (PortData failedJob : errorJobs) {
                        failedJob.connectNotification();
                        failedJob.error();
                        this.log("Error sending '" + failedJob + "'");
                    }
                }
                job.error();
                this.log("Error sending '" + job + "'");
            }
            catch (Throwable ex) {
                OrderMateLog.LOG.error("Uncaught exception in port queue : " + this + " attempting to continue", ex);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    OrderMateLog.LOG.warn("Port queue : " + this + " interrupted.");
                    return;
                }
            }
        }
        this.log("Shutting down PortQueue thread");
        this.closeConnection();
    }

    private String[] splitString(String printJob) {
        if (printJob == null || printJob.isEmpty()) {
            return new String[0];
        }
        int bufferSize = this.port.getBufferSize();
        int numSections = (int)Math.ceil((double)printJob.length() / (double)bufferSize);
        String[] split = new String[numSections];
        for (int i = 0; i < split.length; ++i) {
            int end = i * bufferSize + bufferSize;
            if (end > printJob.length()) {
                end = printJob.length();
            }
            split[i] = printJob.substring(i * bufferSize, end);
        }
        return split;
    }

    private boolean sendNormalMode(PortData printJob) {
        long timeToTry = printJob.getTimeToTry();
        long timeStarted = System.currentTimeMillis();
        boolean timeOut = false;
        String[] printStrings = this.splitString(printJob.getData());
        this.log("Split '" + printJob + "' up into " + printStrings.length + " blocks");
        int i = 0;
        while (i < printStrings.length && !this.stop && !timeOut) {
            long time;
            if (!this.sendData(printStrings[i], printJob.getDescription())) {
                try {
                    this.log("Error occurred sending data for " + printJob.getDescription() + " will wait");
                    Thread.sleep(Math.max(this.port.getErrorWaitTime(), 1000));
                }
                catch (InterruptedException e) {
                    this.log("Interrupted while waiting due to error", e);
                }
            } else {
                ++i;
            }
            timeOut = (time = System.currentTimeMillis() - timeStarted) > timeToTry && timeToTry != 0L;
        }
        if (this.stop || timeOut) {
            this.log("Gave up sending '" + printJob + "'");
            return false;
        }
        this.log("Done sending '" + printJob + "'");
        return true;
    }

    private boolean sendErrorMode(String data, String description) {
        String[] printStrings = this.splitString(data);
        for (int i = 0; i < printStrings.length && !this.stop; ++i) {
            boolean charSent = this.sendData(printStrings[i], description);
            if (charSent) continue;
            return false;
        }
        return true;
    }

    private void handleException(Exception e) {
        if (this.lastException == null) {
            this.log("Error in PortQueue", e);
        } else if (!this.lastException.getClass().equals(e.getClass()) || this.lastException.getMessage() != null && !this.lastException.getMessage().equals(e.getMessage())) {
            this.log("Error in PortQueue", e);
            this.lastException = e;
        } else {
            this.log("Error in PortQueue, same issue as before");
        }
        try {
            Thread.sleep(this.port.getErrorWaitTime());
        }
        catch (InterruptedException e1) {
            this.log("Interrupted while waiting due to error", e);
            Thread.currentThread().interrupt();
        }
    }

    private void openConnection() {
        this.log("Opening connection to port");
        try {
            this.port.openConnection();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private boolean sendData(String toSend, String description) {
        boolean reConnectSleep = false;
        for (int numRetries = 0; !this.stop && numRetries < this.num_retries; ++numRetries) {
            if (!this.port.isOpen()) {
                this.openConnection();
                reConnectSleep = true;
            }
            if (!this.port.isOpen()) continue;
            try {
                for (int tries = 0; !this.port.isCTS() && !this.stop && tries < this.num_retries; ++tries) {
                    this.log("Port not CTS, sleeping " + this.port.getErrorWaitTime() + " while sending data from '" + description + "'");
                    Thread.sleep(this.port.getErrorWaitTime());
                    reConnectSleep = true;
                }
                if (reConnectSleep) {
                    this.log("Since we slept due to the port not being open, we need to wait " + this.port.getReconnectWaitTime() + " for the port to catch up while data from '" + description + "'");
                    Thread.sleep(this.port.getReconnectWaitTime());
                    reConnectSleep = false;
                }
                if (this.stop) {
                    this.log("Stoped sending data from '" + description + "' due to shutdown of port queue");
                    return false;
                }
                if (!this.port.isCTS()) continue;
                this.port.sendData(toSend);
                return true;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return false;
    }

    private void closeConnection() {
        this.log("Closing connection to port");
        int numRetries = 0;
        while (this.port.isOpen() && numRetries < this.num_retries) {
            try {
                this.port.closeConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.handleException(e);
                ++numRetries;
            }
        }
    }

    private boolean messageDone(String printJob) {
        int numRetries = 0;
        boolean done = false;
        while (!done && numRetries < this.num_retries) {
            try {
                this.log("Calling message done for '" + printJob + "'");
                this.port.messageDone();
                this.log("Message closed off '" + printJob + "'");
                done = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.handleException(e);
                ++numRetries;
            }
        }
        return done;
    }

    public void close() {
        this.stop = true;
    }

    public byte[] receiveBytes() {
        if (!this.port.isOpen()) {
            this.openConnection();
        }
        byte[] data = null;
        try {
            data = this.port.receiveBytes();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return data;
    }

    private void log(String toLog) {
        if (this.logging) {
            this.queueLog.info(toLog);
        }
    }

    private void log(String toLog, Throwable error) {
        if (this.logging) {
            this.queueLog.warn(toLog, error);
        }
    }

    private void setLogging(boolean newLogging) {
        this.logging = newLogging;
        this.port.setLogging(this.logging);
    }

    private static class PortData {
        public static final long DEFAULT_TIME_TO_TRY = 60000L;
        private String data = "";
        private String description;
        private NotificationDetails details;
        private IONotification notify;

        public PortData(String newData, String newDescription, NotificationDetails newDetails) {
            this.data = newData;
            this.description = newDescription;
            this.details = newDetails;
            this.notify = null;
        }

        public String getData() {
            return this.data;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description;
        }

        public boolean doNotify() {
            return this.details != null;
        }

        public long getTimeToTry() {
            if (this.doNotify()) {
                return this.details.getTimeToTry();
            }
            return 60000L;
        }

        public void connectNotification() {
            if (this.doNotify()) {
                try {
                    this.notify = (IONotification)SimpleRMI.getObject(this.details.getNotifyHost(), this.details.getRMIName(), this.details.getNotifyPort());
                }
                catch (NotBoundException e) {
                    OrderMateLog.LOG.error("Port queue could not get IONotifier : " + this.details, (Throwable)e);
                }
                catch (RemoteException e) {
                    OrderMateLog.LOG.error("Port queue could not get IONotifier : " + this.details, (Throwable)e);
                }
            }
        }

        public void started() {
            if (this.doNotify() && this.notify != null) {
                try {
                    this.notify.jobStarted(this.details.getJobID());
                }
                catch (RemoteException e) {
                    OrderMateLog.LOG.error("Port queue could not notify of job started : " + this.details, (Throwable)e);
                }
            }
        }

        public void error() {
            if (this.doNotify() && this.notify != null) {
                try {
                    this.notify.jobError(this.details.getJobID());
                }
                catch (RemoteException e) {
                    OrderMateLog.LOG.error("Port queue could not notify of job error : " + this.details, (Throwable)e);
                }
            }
        }

        public void complete() {
            if (this.doNotify() && this.notify != null) {
                try {
                    this.notify.jobComplete(this.details.getJobID());
                }
                catch (RemoteException e) {
                    OrderMateLog.LOG.warn("Port queue could not notify of job complete : " + this.details, (Throwable)e);
                }
            }
        }
    }
}

