/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio;

import au.com.ordermate.networkio.NotificationDetails;
import au.com.ordermate.networkio.PortQueue;
import au.com.ordermate.networkio.RemoteIO;
import au.com.ordermate.networkio.ports.OutputPort;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;

class RemoteIOImpl
extends UnicastRemoteObject
implements RemoteIO {
    private Hashtable portQueues = new Hashtable(5);
    private static final int MAX_SIZE = 255;

    protected RemoteIOImpl() throws RemoteException {
    }

    @Override
    public void shutdown() throws RemoteException {
        for (PortQueue current : this.portQueues.values()) {
            current.close();
        }
        this.portQueues.clear();
    }

    @Override
    public synchronized void startQueue(OutputPort output, String logPrefix) throws Exception {
        if (this.portQueues.containsKey(output.getName())) {
            throw new IOException("Server already started on port");
        }
        PortQueue newQueue = new PortQueue(output, logPrefix);
        this.portQueues.put(output.getName(), newQueue);
    }

    @Override
    public synchronized OutputPort getPort(String portName) throws RemoteException {
        if (!this.portQueues.containsKey(portName)) {
            return null;
        }
        PortQueue queue = (PortQueue)this.portQueues.get(portName);
        OutputPort port = queue.getPort();
        return port;
    }

    @Override
    public synchronized boolean hasQueue(String portName) throws RemoteException {
        return this.portQueues.containsKey(portName);
    }

    @Override
    public void queueData(String data, String port, String description) throws RemoteException {
        if (!this.portQueues.containsKey(port)) {
            throw new RemoteException("No server started on port " + port);
        }
        PortQueue theQueue = (PortQueue)this.portQueues.get(port);
        if (theQueue.getSize() > 255) {
            throw new RemoteException("Maximum number of dockets in queue has been reached for port " + port + ", size is " + theQueue.getSize());
        }
        theQueue.add(data, description, null);
    }

    @Override
    public void queueData(String data, String port, String description, NotificationDetails details) throws RemoteException {
        if (!this.portQueues.containsKey(port)) {
            throw new RemoteException("No server started on port " + port);
        }
        PortQueue theQueue = (PortQueue)this.portQueues.get(port);
        if (theQueue.getSize() > 255) {
            throw new RemoteException("Maximum number of dockets in queue has been reached for port " + port + ", size is " + theQueue.getSize());
        }
        theQueue.add(data, description, details);
    }
}

