/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio.escpos;

class BitStatus {
    private int bit;
    private String description;
    private String bitOnDesc;
    private String bitOffDesc;

    public BitStatus(int bit, String description, String bitOffDesc, String bitOnDesc) {
        this.bit = bit;
        this.description = description;
        this.bitOffDesc = bitOffDesc;
        this.bitOnDesc = bitOnDesc;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBitOnDesc() {
        return this.bitOnDesc;
    }

    public String getBitOffDesc() {
        return this.bitOffDesc;
    }

    public String getStatusFor(byte response) {
        if ((response & 1 << this.bit) == 1 << this.bit) {
            return this.description + " - " + this.bitOnDesc;
        }
        return this.description + " - " + this.bitOffDesc;
    }

    static class NotUsedBitStatus
    extends BitStatus {
        public NotUsedBitStatus(int bit) {
            super(bit, "Not Used", "Not Used", "Not Used");
        }
    }

    static class HasPaperBitStatus
    extends BitStatus {
        public HasPaperBitStatus(int bit, String description) {
            super(bit, description, "Has Paper", "Paper Out");
        }
    }

    static class ErrorBitStatus
    extends BitStatus {
        public ErrorBitStatus(int bit) {
            this(bit, "Error");
        }

        public ErrorBitStatus(int bit, String description) {
            super(bit, description, "No Error", "Error");
        }
    }

    static class ClosedOpenBitStatus
    extends BitStatus {
        public ClosedOpenBitStatus(int bit, String description) {
            super(bit, description, "Closed", "Open");
        }
    }

    static class FixedBitStatus
    extends BitStatus {
        public FixedBitStatus(int bit, int value) {
            super(bit, "Fixed at " + value, "", "");
        }
    }

    static class UndefinedStatus
    extends BitStatus {
        public UndefinedStatus(int bit) {
            super(bit, "Undefinded", "", "");
        }
    }
}

