/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio.ports;

import au.com.ordermate.networkio.ports.OutputPort;
import au.com.ordermate.util.StringUtils;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import javax.comm.CommDriver;
import javax.comm.CommPortOwnershipListener;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.apache.commons.lang.SystemUtils;

public abstract class CommPort
implements OutputPort,
CommPortOwnershipListener {
    protected String errorCommandString = null;
    private static final int PORT_SHUTDOWN_TIME = 30000;
    public static final int DEFAULT_RECONNECT_SLEEP = 0;
    public static final int PRINTER_RECONNECT_SLEEP = 1000;
    private static final int ERROR_WAIT_TIME = 1000;
    private static final int BUFFER_SIZE = 32;
    private static boolean commDriverLoaded = false;
    private String portName;
    private javax.comm.CommPort port;
    private int reconnectSleep;
    private OutputStreamWriter writer;
    private String encoding = null;
    private final Signal dataAvailable = Signals.createSignal();
    protected OutputPort.BufferedLogger portLog;
    boolean logging = false;

    public CommPort(String name, int reconnectSleepTime, String charEncoding) {
        if (name == null) {
            throw new IllegalArgumentException("Port name cannot be null.  Must be COM1, LPT1, etc");
        }
        this.encoding = charEncoding;
        this.portName = name;
        this.reconnectSleep = reconnectSleepTime;
        this.portLog = new OutputPort.BufferedLogger(name);
    }

    public static void manualLoadCommDriver() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (SystemUtils.IS_OS_WINDOWS && !commDriverLoaded) {
            String driverName = "com.sun.comm.Win32Driver";
            CommDriver commDriver = (CommDriver)Class.forName(driverName).newInstance();
            commDriver.initialize();
            commDriverLoaded = true;
        }
    }

    @Override
    public int getBufferSize() {
        return 32;
    }

    @Override
    public void sendData(String toSend) throws Exception {
        if (this.port != null) {
            this.logData(toSend, this.portLog);
            if (this.encoding != null) {
                if (this.writer == null) {
                    this.writer = new OutputStreamWriter(this.port.getOutputStream(), this.encoding);
                }
                this.writer.write(toSend);
            } else {
                this.port.getOutputStream().write(toSend.getBytes());
            }
        } else {
            this.portLog.getRawLog().error("PORT NOT OPENED");
            throw new IOException("Port not opened!");
        }
    }

    @Override
    public void messageDone() throws Exception {
        this.portLog.flushBuffer();
        if (this.port == null) {
            throw new IOException("Port not opened!");
        }
        if (this.writer != null) {
            this.writer.flush();
        } else {
            this.port.getOutputStream().flush();
        }
    }

    @Override
    public void closeConnection() throws Exception {
        this.portLog.getRawLog().info("CLOSING CONNECTION");
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.port != null) {
            this.port.close();
            this.port = null;
            this.portLog.getRawLog().info("PORT CLOSED.");
        }
    }

    @Override
    public String getName() {
        return this.portName;
    }

    @Override
    public boolean isOpen() {
        boolean open = this.port != null;
        return open;
    }

    protected final void setPort(javax.comm.CommPort newPort) {
        this.portLog.flushBuffer();
        this.port = newPort;
    }

    protected final javax.comm.CommPort getPort() {
        return this.port;
    }

    @Override
    public int getAutoShutdownTime() {
        return 30000;
    }

    @Override
    public int getReconnectWaitTime() {
        return this.reconnectSleep;
    }

    @Override
    public int getErrorWaitTime() {
        return 1000;
    }

    @Override
    public boolean hasData() throws Exception {
        boolean hasData = false;
        if (this.port == null) {
            this.portLog.flushBuffer();
            throw new IOException("Port not opened!");
        }
        InputStream in = this.port.getInputStream();
        hasData = in.available() > 0;
        return hasData;
    }

    public String toString() {
        String str = this.getName();
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] receiveBytes() throws Exception {
        byte[] incoming = new byte[1];
        if (this.getPort() == null) {
            throw new IOException("Port not opened!");
        }
        DataInputStream input = new DataInputStream(this.getPort().getInputStream());
        int count = 0;
        boolean ok = true;
        while (ok) {
            try {
                byte current;
                incoming[count] = current = input.readByte();
                ++count;
                incoming = StringUtils.resizeArray(incoming, 1);
                this.portLog.logData(Byte.valueOf(current).toString());
            }
            catch (EOFException e) {
                ok = false;
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    this.portLog.logData("Cannot close off the input:" + ex);
                }
            }
        }
        return incoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] receiveBytes(int nBytes) throws Exception {
        if (nBytes <= 0) {
            return null;
        }
        byte[] incoming = new byte[nBytes];
        if (this.getPort() == null) {
            throw new IOException("Port not opened!");
        }
        DataInputStream input = new DataInputStream(this.getPort().getInputStream());
        int count = 0;
        boolean ok = true;
        while (ok) {
            try {
                byte current = input.readByte();
                incoming[count++] = current;
                if (count == nBytes) break;
                if (count < incoming.length) continue;
                incoming = StringUtils.resizeArray(incoming, 1);
            }
            catch (EOFException e) {
                ok = false;
                byte[] byArray = incoming;
                return byArray;
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    this.portLog.logData("Cannot close off the input:" + ex);
                }
            }
        }
        return incoming;
    }

    public void ownershipChange(int type) {
        String description = "";
        if (type == 1) {
            description = "Port went to owned state";
        } else if (type == 2) {
            description = "Port went to unowned state";
        } else if (type == 3) {
            description = "Another application requested ownership";
        }
        this.portLog.getRawLog().info(this.getName() + " PORT OWNERSHIP EVENT: " + description);
    }

    @Override
    public void setErrorCommandString(String command) {
        this.errorCommandString = command;
    }

    @Override
    public String getErrorCommandString() {
        return this.errorCommandString;
    }

    @Override
    public void logData(String data, OutputPort.BufferedLogger log) {
        if (!this.isLogging()) {
            return;
        }
        log.logData(data);
    }

    @Override
    public boolean isLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(boolean logIt) {
        this.logging = logIt;
    }

    @Override
    public Signal getDataAvailableSignal() {
        return this.dataAvailable;
    }
}

