/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio.ports;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.networkio.ports.GuiPortDisplay;
import au.com.ordermate.networkio.ports.GuiPortFrame;
import au.com.ordermate.networkio.ports.OutputPort;
import java.util.List;
import javax.swing.SwingUtilities;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;

public class GuiPort
implements OutputPort {
    private static final int PORT_SHUTDOWN_TIME = 30000;
    private GuiPortDisplay display;
    private boolean open;
    private String name;
    private StringBuffer currentReceivingData = new StringBuffer();
    private boolean logging = false;
    private boolean throwEx = false;
    OutputPort.BufferedLogger portLog;
    private final Signal dataAvailable = Signals.createSignal();
    private byte[] receiveData = new byte[0];
    protected boolean initialized;

    public GuiPort(String portName) {
        this.name = portName;
        this.portLog = new OutputPort.BufferedLogger(portName);
    }

    public void init() {
        final GuiPort thisPort = this;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GuiPort.this.display = new GuiPortDisplay();
                    GuiPort.addToStaticFrame(GuiPort.this.name, GuiPort.this.display);
                    ((GuiPort)GuiPort.this).display.clearAll.connect(thisPort, "clearAll");
                    ((GuiPort)GuiPort.this).display.sendDataToBeReceived.connect(thisPort, "sendDataToBeReceived");
                    GuiPort.this.display.setName(GuiPort.this.name);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating gui port gui", ex);
        }
        this.initialized = true;
    }

    private static void addToStaticFrame(String portName, GuiPortDisplay display) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Should be event dispatch thread.");
        }
        GuiPortFrame.createInstance();
        GuiPortFrame.getInstance().addPanelToTab(portName, display);
    }

    public void clearAll() {
        if (GuiPortFrame.getInstance() != null) {
            GuiPortFrame.getInstance().clearAll();
        }
    }

    public synchronized void clearDockets() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiPort.this.display.clearDockets();
            }
        });
    }

    public synchronized List<String> getDockets() {
        return this.display.getDockets();
    }

    private void throwException() throws Exception {
        this.throwEx = false;
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GuiPort.this.throwEx = GuiPort.this.display.shouldThrowExceptions();
            }
        });
        if (this.throwEx) {
            Thread.sleep(5L);
            throw new Exception("Throws exceptions is enabled");
        }
    }

    public void setExceptions(final boolean doThrow) throws Exception {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GuiPort.this.display.setThrowsExceptions(doThrow);
            }
        });
    }

    public boolean shouldThrowExceptions() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GuiPort.this.throwEx = GuiPort.this.display.shouldThrowExceptions();
                }
            });
        }
        catch (Exception ex) {
            OrderMateLog.LOG.error("exception caught checking if we should throw exceptions", (Throwable)ex);
            return true;
        }
        return this.throwEx;
    }

    @Override
    public void openConnection() throws Exception {
        this.throwException();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GuiPort.this.display.setEnabledIcon(true);
                GuiPort.this.open = true;
            }
        });
    }

    @Override
    public synchronized void sendData(String toSend) throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("Must call init before sending data");
        }
        this.throwException();
        this.currentReceivingData.append(toSend);
        this.logData(toSend, this.portLog);
    }

    @Override
    public int getBufferSize() {
        return 16;
    }

    @Override
    public synchronized void messageDone() throws Exception {
        String data = this.currentReceivingData.toString();
        this.currentReceivingData = new StringBuffer();
        this.display.appendText(data);
        this.portLog.flushBuffer();
    }

    @Override
    public void closeConnection() throws Exception {
        this.throwException();
        this.display.setEnabledIcon(false);
        this.open = false;
    }

    @Override
    public int getAutoShutdownTime() {
        return 30000;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isCTS() {
        return true;
    }

    public String receiveData() throws Exception {
        return ArrayUtils.toString((Object)this.receiveBytes());
    }

    @Override
    public boolean hasData() throws Exception {
        return this.receiveData.length > 0;
    }

    @Override
    public byte[] receiveBytes() throws Exception {
        byte[] retVal = this.receiveData;
        this.receiveData = new byte[0];
        return retVal;
    }

    @Override
    public byte[] receiveBytes(int nBytes) throws Exception {
        throw new NotImplementedException("Receive bytes not implemented for gui port");
    }

    @Override
    public int getReconnectWaitTime() {
        return 0;
    }

    @Override
    public int getErrorWaitTime() {
        return 0;
    }

    @Override
    public void setErrorCommandString(String command) {
    }

    @Override
    public String getErrorCommandString() {
        return "";
    }

    @Override
    public boolean isLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(boolean newLogging) {
        this.logging = newLogging;
    }

    @Override
    public void logData(String data, OutputPort.BufferedLogger log) {
        if (this.isLogging()) {
            log.logData(data);
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Signal getDataAvailableSignal() {
        return this.dataAvailable;
    }

    public void sendDataToBeReceived(String data) {
        byte[] dataBuffer = new byte[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            dataBuffer[i] = (byte)data.charAt(i);
        }
        this.receiveData = dataBuffer;
        this.getDataAvailableSignal().emit();
    }
}

