/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio.ports;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class GuiPortDisplay
extends JPanel
implements ActionListener {
    public Signal sendDataToBeReceived = Signals.createSignal(String.class, "dataString");
    public Signal clearAll = Signals.createSignal();
    private DefaultListModel model = new DefaultListModel();
    private JList output;
    private JCheckBox throwExceptionCheck;
    private JButton clearButton;
    private JButton clearAllButton;
    private JButton copyButton;
    private JLabel activeLabel;
    private JLabel numDocketLabel;
    private int numDockets;
    private List<String> dockets = new ArrayList<String>();

    public GuiPortDisplay() {
        this.checkSwing();
        this.setLayout(new BorderLayout());
        this.output = new JList(this.model);
        this.output.setFont(Font.decode("Courier"));
        this.output.setCellRenderer(new GuiPortCellRenderer());
        this.add(new JScrollPane(this.output));
        JPanel controlPanel = new JPanel();
        this.activeLabel = new JLabel(new ImageIcon(this.getClass().getResource("/ordermate/images/connectionOff.png")));
        controlPanel.add(this.activeLabel);
        this.throwExceptionCheck = new JCheckBox("Throw exceptions");
        this.throwExceptionCheck.addActionListener(this);
        controlPanel.add(this.throwExceptionCheck);
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(this);
        controlPanel.add(this.clearButton);
        this.clearAllButton = new JButton("Clear All");
        this.clearAllButton.addActionListener(this);
        controlPanel.add(this.clearAllButton);
        this.copyButton = new JButton("Copy");
        this.copyButton.addActionListener(this);
        this.copyButton.setToolTipText("Copy dockets to clipboard");
        controlPanel.add(this.copyButton);
        this.numDocketLabel = new JLabel("0 Docket(s)");
        controlPanel.add(this.numDocketLabel);
        this.add((Component)controlPanel, "South");
    }

    public List<String> getDockets() {
        return new ArrayList<String>(this.dockets);
    }

    void appendText(String toDisplay) {
        ++this.numDockets;
        SwingUtilities.invokeLater(new TextSetter(toDisplay));
        this.dockets.add(toDisplay);
    }

    public boolean shouldThrowExceptions() {
        this.checkSwing();
        return this.throwExceptionCheck.isSelected();
    }

    protected void setThrowsExceptions(boolean doThrow) {
        this.checkSwing();
        if (doThrow) {
            if (!this.throwExceptionCheck.isSelected()) {
                this.throwExceptionCheck.doClick();
            }
        } else if (this.throwExceptionCheck.isSelected()) {
            this.throwExceptionCheck.doClick();
        }
    }

    public void copyDocketsToClipboard() {
        this.checkSwing();
        StringBuffer buffer = new StringBuffer();
        Enumeration e = this.model.elements();
        while (e.hasMoreElements()) {
            buffer.append(e.nextElement().toString());
            buffer.append('\n');
        }
        StringSelection ss = new StringSelection(buffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
    }

    public void clearDockets() {
        this.checkSwing();
        DefaultListModel model = (DefaultListModel)this.output.getModel();
        this.numDockets = 0;
        this.numDocketLabel.setText("0 Docket(s)");
        model.clear();
        this.dockets.clear();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.clearButton) {
            this.clear();
        } else if (e.getSource() == this.clearAllButton) {
            this.clearAll.emit();
        } else if (e.getSource() == this.copyButton) {
            this.copyDocketsToClipboard();
        }
    }

    void clear() {
        this.checkSwing();
        DefaultListModel model = (DefaultListModel)this.output.getModel();
        this.numDockets = 0;
        this.numDocketLabel.setText("0 Docket(s)");
        model.clear();
    }

    void setEnabledIcon(boolean enabled) {
        SwingUtilities.invokeLater(new EnabledSetter(enabled));
    }

    private void checkSwing() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Should be on event dispatch thread");
        }
    }

    static class GuiPortCellRenderer
    extends JTextArea
    implements ListCellRenderer {
        private boolean isSetup;

        GuiPortCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!this.isSetup) {
                EmptyBorder buffer = new EmptyBorder(5, 5, 5, 5);
                LineBorder line = new LineBorder(new Color(134, 134, 150), 2);
                CompoundBorder inner = new CompoundBorder(buffer, line);
                CompoundBorder outer = new CompoundBorder(inner, buffer);
                this.setBorder(outer);
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.isSetup = true;
            }
            String s = value.toString();
            this.setText(s);
            super.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(false);
            return this;
        }
    }

    private class EnabledSetter
    implements Runnable {
        private boolean enabled;

        public EnabledSetter(boolean isEnabled) {
            this.enabled = isEnabled;
        }

        @Override
        public void run() {
            GuiPortDisplay.this.checkSwing();
            if (this.enabled) {
                GuiPortDisplay.this.activeLabel.setIcon(new ImageIcon(this.getClass().getResource("/ordermate/images/connectionOn.png")));
            } else {
                GuiPortDisplay.this.activeLabel.setIcon(new ImageIcon(this.getClass().getResource("/ordermate/images/connectionOff.png")));
            }
        }
    }

    private class TextSetter
    implements Runnable {
        private String display;

        public TextSetter(String displayString) {
            this.display = displayString;
        }

        @Override
        public void run() {
            DefaultListModel model = (DefaultListModel)GuiPortDisplay.this.output.getModel();
            GuiPortDisplay.this.numDocketLabel.setText(GuiPortDisplay.this.numDockets + " Docket(s)");
            model.add(0, this.display);
            if (model.getSize() > 20) {
                model.remove(model.getSize() - 1);
            }
        }
    }
}

