/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio.ports;

import au.com.ordermate.networkio.ports.GuiPort;
import au.com.ordermate.networkio.ports.GuiPortDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import ordermate.OrderMate;

public final class GuiPortFrame
extends JFrame {
    private static GuiPortFrame instance;
    private JTabbedPane outputTabs;

    private GuiPortFrame() {
        super("OrderMate Software Printer");
        this.setupComponents();
    }

    public static final GuiPortFrame getInstance() {
        return instance;
    }

    public static final void createInstance() {
        if (instance == null) {
            instance = new GuiPortFrame();
        }
    }

    private void setupComponents() {
        this.outputTabs = new JTabbedPane();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.outputTabs, "Center");
        this.setSize(480, 600);
        int x = Preferences.userNodeForPackage(GuiPort.class).getInt("LocationX", 0);
        int y = Preferences.userNodeForPackage(GuiPort.class).getInt("LocationY", 0);
        this.setLocation(x, y);
        this.setVisible(true);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                Preferences.userNodeForPackage(GuiPort.class).putInt("LocationX", GuiPortFrame.this.getX());
                Preferences.userNodeForPackage(GuiPort.class).putInt("LocationY", GuiPortFrame.this.getY());
                try {
                    Preferences.userNodeForPackage(GuiPort.class).flush();
                }
                catch (BackingStoreException e) {
                    OrderMate.LOG.warn("Error saving gui printer location", (Throwable)e);
                }
            }
        }));
    }

    public void clearAll() {
        for (int i = 0; i < this.outputTabs.getTabCount(); ++i) {
            JPanel panel = (JPanel)this.outputTabs.getComponentAt(i);
            if (!(panel instanceof GuiPortDisplay)) continue;
            ((GuiPortDisplay)panel).clear();
        }
    }

    public void addPanelToTab(String portName, JPanel display) {
        this.outputTabs.addTab(portName, display);
    }

    public Component getPanel(String name) {
        for (int i = 0; i < this.outputTabs.getTabCount(); ++i) {
            if (!name.equals(this.outputTabs.getComponentAt(i).getName())) continue;
            return this.outputTabs.getComponentAt(i);
        }
        return null;
    }
}

