/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio.ports;

import au.com.ordermate.networkio.escpos.BaseByteConverter;
import au.com.ordermate.networkio.escpos.ESCPOSDLEEOTStatusType;
import au.com.ordermate.networkio.ports.OutputPort;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import ordermate.OrderMate;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.apache.logging.log4j.Level;

public class IPPort
implements OutputPort {
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    public static final int DEFAULT_RECONNECT_SLEEP = 1000;
    private static final int PORT_SHUTDOWN_TIME = 30000;
    private static final int ERROR_WAIT_TIME = 1000;
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int TIME_DELAY_FOR_DLE_RESPONSE = 250;
    private String ipAddress;
    private int port;
    private Socket socket;
    private OutputStreamWriter out;
    private BufferedInputStream in;
    private boolean logging = true;
    private String errorCommandString;
    private final Signal dataAvailable = Signals.createSignal();
    private String encoding = null;
    private static final int NUM_FAILURES_BETWEEN_ABS_STATUS_LOGGING = 30;
    private int numOfflineStatusFromPrinter = 0;
    private OutputPort.BufferedLogger portLog;

    public IPPort(String ipAddress, int port, String encoding) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.encoding = encoding;
        this.portLog = new OutputPort.BufferedLogger(ipAddress);
    }

    public IPPort(String ipAddress, int port) {
        this(ipAddress, port, null);
    }

    @Override
    public Signal getDataAvailableSignal() {
        return this.dataAvailable;
    }

    @Override
    public void openConnection() throws Exception {
        this.socket = new Socket();
        this.socket.setSendBufferSize(131072);
        this.socket.connect(new InetSocketAddress(this.ipAddress, this.port), 5000);
        this.out = this.encoding != null ? new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.socket.getOutputStream()), this.encoding) : new OutputStreamWriter(new BufferedOutputStream(this.socket.getOutputStream()));
        this.in = new BufferedInputStream(new DataInputStream(this.socket.getInputStream()));
    }

    @Override
    public void sendData(String toSend) throws Exception {
        this.logData(toSend, this.portLog);
        this.out.write(toSend);
    }

    @Override
    public void messageDone() throws Exception {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.out.flush();
            }
            catch (IOException ex) {
                OrderMate.LOG.log(Level.WARN, "Cannot flush socket buffer", (Throwable)ex);
            }
        }
    }

    @Override
    public void closeConnection() throws IOException {
        this.out.close();
        this.in.close();
        this.socket.close();
    }

    @Override
    public int getAutoShutdownTime() {
        return 30000;
    }

    @Override
    public int getReconnectWaitTime() {
        return 1000;
    }

    @Override
    public int getErrorWaitTime() {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                return this.socket.getSoTimeout();
            }
        }
        catch (SocketException ex) {
            OrderMate.LOG.error("Could not retreive error wait time", (Throwable)ex);
        }
        return 1000;
    }

    @Override
    public String getName() {
        return this.ipAddress;
    }

    @Override
    public boolean isOpen() {
        return this.socket != null && !this.socket.isClosed();
    }

    @Override
    public boolean isCTS() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed() && this.checkPrinterStatusOnline();
    }

    private boolean checkPrinterStatusOnline() {
        try {
            StringBuilder sendCommand = new StringBuilder();
            sendCommand.append('\u0010').append('\u0004').append('\u0001');
            this.sendData(sendCommand.toString());
            this.messageDone();
            Thread.sleep(250L);
            if (this.hasData()) {
                byte[] response = this.receiveBytes();
                OrderMate.LOG.info("DLE EOT Printer status: " + Arrays.toString(response));
                boolean responseOk = (response[response.length - 1] & 8) == 0;
                int n = this.numOfflineStatusFromPrinter = responseOk ? 0 : this.numOfflineStatusFromPrinter + 1;
                if (!responseOk && this.numOfflineStatusFromPrinter % 30 == 0) {
                    this.fetchAndLogPrinterStatus();
                }
                return responseOk;
            }
            OrderMate.LOG.warn("Printer did not return its status, will be marked as not CTS");
        }
        catch (Exception ex) {
            this.handleSocketException();
            OrderMate.LOG.error("Error checking printer status", (Throwable)ex);
        }
        return false;
    }

    private void handleSocketException() {
        try {
            this.closeConnection();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error closing port for reset", (Throwable)ex);
        }
    }

    @Override
    public void setErrorCommandString(String command) {
        this.errorCommandString = command;
    }

    @Override
    public String getErrorCommandString() {
        return this.errorCommandString;
    }

    @Override
    public boolean hasData() throws Exception {
        if (!this.socket.isClosed()) {
            return this.in.available() > 0;
        }
        return false;
    }

    @Override
    public byte[] receiveBytes() throws Exception {
        return this.receiveBytes(this.in.available());
    }

    @Override
    public byte[] receiveBytes(int nBytes) throws Exception {
        if (this.socket == null || !this.socket.isConnected()) {
            throw new IOException("Socket is not connected");
        }
        if (this.socket.isClosed()) {
            throw new IOException("Socket is closed");
        }
        byte[] result = new byte[nBytes];
        this.in.read(result);
        return result;
    }

    @Override
    public boolean isLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(boolean isLogging) {
        this.logging = isLogging;
    }

    @Override
    public void logData(String data, OutputPort.BufferedLogger log) {
        if (this.isLogging()) {
            log.logData(data);
        }
    }

    @Override
    public int getBufferSize() {
        if (this.socket != null && this.socket.isConnected() && !this.socket.isClosed()) {
            try {
                return this.socket.getSendBufferSize();
            }
            catch (SocketException ex) {
                OrderMate.LOG.error("Could not retreive buffer size", (Throwable)ex);
            }
        }
        return 131072;
    }

    private void sendESCPOSDLEEOTSCommand(ESCPOSDLEEOTStatusType statusType) {
        try {
            StringBuilder sendCommand = new StringBuilder();
            sendCommand.append('\u0010').append('\u0004').append((char)statusType.getCommand());
            this.sendData(sendCommand.toString());
            this.messageDone();
            byte[] response = this.receiveBytes(1);
            OrderMate.LOG.info("DLE EOT Printer Status " + (Object)((Object)statusType) + ": " + Arrays.toString(response));
            if (response != null && response.length == 1) {
                OrderMate.LOG.info(BaseByteConverter.convertStatusByteToDescription(statusType, response[0]));
            }
        }
        catch (Exception ex) {
            this.handleSocketException();
            OrderMate.LOG.error("Error checking printer status", (Throwable)ex);
        }
    }

    private void fetchAndLogPrinterStatus() {
        for (ESCPOSDLEEOTStatusType statusType : ESCPOSDLEEOTStatusType.values()) {
            this.sendESCPOSDLEEOTSCommand(statusType);
        }
    }
}

