/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio.ports;

import au.com.ordermate.OMLogUtil;
import au.com.ordermate.OrderMateLog;
import ordermate.signals.Signal;
import org.apache.logging.log4j.core.Logger;

public interface OutputPort {
    public static final int DEFAULT_BUFFER_SIZE = 16;

    public Signal getDataAvailableSignal();

    public void openConnection() throws Exception;

    public void sendData(String var1) throws Exception;

    public void messageDone() throws Exception;

    public void closeConnection() throws Exception;

    public int getAutoShutdownTime();

    public int getReconnectWaitTime();

    public int getErrorWaitTime();

    public String getName();

    public boolean isOpen();

    public boolean isCTS();

    public int hashCode();

    public boolean equals(Object var1);

    public void setErrorCommandString(String var1);

    public String getErrorCommandString();

    public boolean hasData() throws Exception;

    public byte[] receiveBytes() throws Exception;

    public byte[] receiveBytes(int var1) throws Exception;

    public boolean isLogging();

    public void setLogging(boolean var1);

    public void logData(String var1, BufferedLogger var2);

    public int getBufferSize();

    public static class BufferedLogger {
        private final int DEFAULT_LOG_BUFFER_SIZE = 1024;
        private String buffer;
        private Logger theLog;
        private int bufferSize = 1024;

        public BufferedLogger(String logName) {
            this.theLog = OrderMateLog.createLogger(OMLogUtil.getOutputPortParentFolder(), logName);
            this.theLog.setAdditive(false);
            this.buffer = new String();
        }

        public BufferedLogger(String logName, int newBufferSize) {
            this(logName);
            this.bufferSize = newBufferSize;
        }

        public void logData(String data) {
            this.buffer = this.buffer + data;
            if (this.buffer.length() >= this.bufferSize) {
                this.flushBuffer();
            }
        }

        public int flushBuffer() {
            if (this.buffer.length() > 0) {
                this.theLog.info(this.buffer);
            }
            int retVal = this.buffer.length();
            this.buffer = "";
            return retVal;
        }

        public Logger getRawLog() {
            this.flushBuffer();
            return this.theLog;
        }
    }
}

