/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio.ports;

import au.com.ordermate.networkio.ports.CommPort;
import java.io.IOException;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.ParallelPortEvent;
import javax.comm.ParallelPortEventListener;
import ordermate.OrderMate;

public class ParallelPort
extends CommPort
implements ParallelPortEventListener {
    public ParallelPort(String name) {
        this(name, 0, null);
    }

    public ParallelPort(String name, int reconnectTime, String charEncoding) {
        super(name, reconnectTime, charEncoding);
    }

    @Override
    public void openConnection() throws Exception {
        CommPortIdentifier currentPort;
        ParallelPort.manualLoadCommDriver();
        try {
            currentPort = CommPortIdentifier.getPortIdentifier((String)this.getName().toUpperCase());
            currentPort.addPortOwnershipListener((CommPortOwnershipListener)this);
        }
        catch (NoSuchPortException e) {
            throw new IOException("Port " + this.getName() + " cannot be found", e);
        }
        javax.comm.ParallelPort newPort = (javax.comm.ParallelPort)currentPort.open("Ordermate Parellel connection", 30000);
        newPort.setMode(1);
        newPort.notifyOnBuffer(true);
        newPort.notifyOnError(true);
        newPort.addEventListener((ParallelPortEventListener)this);
        this.setPort((javax.comm.CommPort)newPort);
    }

    @Override
    public boolean isCTS() {
        javax.comm.ParallelPort pPort = (javax.comm.ParallelPort)this.getPort();
        boolean cts = !pPort.isPrinterBusy() && !pPort.isPaperOut() && !pPort.isPrinterError();
        return cts;
    }

    public void parallelEvent(ParallelPortEvent event) {
        if (event.getEventType() == 1) {
            this.close();
        } else if (event.getEventType() == 2) {
            this.getDataAvailableSignal().emit();
        }
    }

    private void close() {
        try {
            this.closeConnection();
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error closing port " + this.getName(), (Throwable)e);
        }
    }
}

