/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio.ports;

import au.com.ordermate.networkio.ports.CommPort;
import java.io.IOException;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import ordermate.database.hardware.physical.PortParity;

public class SerialPort
extends CommPort
implements SerialPortEventListener {
    public static final String FLOW_CONTROL_NONE = "None";
    public static final String FLOW_CONTROL_DELAY = "Delay";
    public static final String FLOW_CONTROL_XONXOFF = "XonXoff";
    public static final String FLOW_CONTROL_DTSDTR = "DtrDsr";
    private static final int OPEN_TIMEOUT = 30000;
    private int baudRate;
    private boolean registerCallBack;
    private String flowControl;
    private PortParity parity = PortParity.None;
    private int stopBits = 1;
    private int dataBits = 8;
    private CommPortIdentifier currentPort;

    public SerialPort(String name, int portBaudRate, boolean callBack, String newFlowControl) {
        this(name, portBaudRate, callBack, 0, newFlowControl, null);
    }

    public SerialPort(String name, int portBaudRate, boolean callBack, int reconnectSleep, String newFlowControl, String charEncoding) {
        super(name, reconnectSleep, charEncoding);
        this.baudRate = portBaudRate;
        this.registerCallBack = callBack;
        this.flowControl = newFlowControl;
    }

    public void setDataBits(int value) {
        this.dataBits = value;
    }

    public void setStopBits(int value) {
        this.stopBits = value;
    }

    public void setParity(PortParity value) {
        this.parity = value;
    }

    @Override
    public void openConnection() throws Exception {
        javax.comm.SerialPort sPort;
        SerialPort.manualLoadCommDriver();
        if (this.currentPort == null) {
            try {
                this.currentPort = CommPortIdentifier.getPortIdentifier((String)this.getName().toUpperCase());
                this.currentPort.addPortOwnershipListener((CommPortOwnershipListener)this);
            }
            catch (NoSuchPortException e) {
                throw new IOException("Port " + this.getName() + " cannot be found", e);
            }
        }
        this.portLog.getRawLog().info("Realising Serial Port " + this.getName());
        try {
            sPort = (javax.comm.SerialPort)this.currentPort.open("Ordermate Serial connection", 30000);
        }
        catch (PortInUseException e) {
            throw new IOException("Port " + this.getName() + " currently in use by another application.", e);
        }
        catch (Throwable e) {
            throw new IOException("Could not realise serial port " + this.getName(), e);
        }
        this.portLog.getRawLog().info("Serial Port has been realised " + this.getName());
        sPort.setSerialPortParams(this.baudRate, this.dataBits, this.stopBits, this.parity.getParity());
        sPort.enableReceiveTimeout(100);
        if (this.flowControl.equals(FLOW_CONTROL_NONE) || this.flowControl.equals(FLOW_CONTROL_DELAY)) {
            sPort.setFlowControlMode(0);
        } else if (this.flowControl.equals(FLOW_CONTROL_XONXOFF)) {
            sPort.setFlowControlMode(8);
        } else if (this.flowControl.equals(FLOW_CONTROL_DTSDTR)) {
            sPort.setFlowControlMode(2);
        }
        if (this.registerCallBack) {
            sPort.addEventListener((SerialPortEventListener)this);
            sPort.notifyOnDataAvailable(true);
            sPort.notifyOnBreakInterrupt(true);
            sPort.notifyOnCTS(true);
            sPort.notifyOnOverrunError(true);
            sPort.notifyOnCarrierDetect(true);
        }
        this.portLog.getRawLog().info("PORT OPENED " + this.getName());
        this.setPort((javax.comm.CommPort)sPort);
    }

    @Override
    public void sendData(String toSend) throws Exception {
        if (this.flowControl.equals(FLOW_CONTROL_DELAY)) {
            Thread.sleep(9L);
        }
        super.sendData(toSend);
        if (this.flowControl.equals(FLOW_CONTROL_DELAY)) {
            this.messageDone();
        }
    }

    @Override
    public void closeConnection() throws Exception {
        if (this.currentPort != null) {
            this.currentPort.removePortOwnershipListener((CommPortOwnershipListener)this);
            this.currentPort = null;
        }
        javax.comm.SerialPort sPort = (javax.comm.SerialPort)this.getPort();
        sPort.removeEventListener();
        super.closeConnection();
    }

    @Override
    public boolean isCTS() {
        javax.comm.SerialPort sPort = (javax.comm.SerialPort)this.getPort();
        boolean cts = sPort.isCTS();
        return cts;
    }

    public void serialEvent(SerialPortEvent event) {
        String description = "";
        if (event.getEventType() == 3) {
            if (!event.getNewValue()) {
                description = "Device not CTS";
            }
            if (event.getNewValue()) {
                description = "Device CTS";
            }
        } else if (event.getEventType() == 7 && event.getNewValue()) {
            description = "Overrun Error";
        } else if (event.getEventType() == 6) {
            description = "Carrier Detect bit change";
        } else if (event.getEventType() == 10) {
            description = "Break Interrupt";
        } else if (event.getEventType() == 1) {
            description = "Data Avail";
            this.getDataAvailableSignal().emit();
        }
        this.portLog.logData("Port Event: " + description);
    }
}

