/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.networkio.ports;

import au.com.ordermate.networkio.ports.GuiPort;
import java.util.ArrayList;
import java.util.List;

public class ServerGuiPort
extends GuiPort {
    private List<String> dockets = new ArrayList<String>();
    private int numDockets = 0;
    private boolean open = false;
    private StringBuffer currentReceivingData = new StringBuffer();

    public ServerGuiPort(String portName) {
        super(portName);
    }

    @Override
    public void init() {
        this.initialized = true;
    }

    @Override
    public synchronized void clearDockets() {
        this.dockets.clear();
    }

    @Override
    public synchronized List<String> getDockets() {
        return this.dockets;
    }

    @Override
    public void openConnection() throws Exception {
        this.open = true;
    }

    @Override
    public boolean hasData() throws Exception {
        return this.currentReceivingData.length() > 0;
    }

    @Override
    public synchronized void sendData(String toSend) throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("Must call init before sending data");
        }
        this.currentReceivingData.append(toSend);
        this.logData(toSend, this.portLog);
    }

    @Override
    public synchronized void messageDone() throws Exception {
        String data = this.currentReceivingData.toString();
        this.currentReceivingData = new StringBuffer();
        this.dockets.add(data);
        this.portLog.flushBuffer();
    }

    @Override
    public void closeConnection() throws Exception {
        this.open = false;
    }
}

