/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.operator;

import au.com.ordermate.operator.Operator;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractOperator<T>
implements Operator<T> {
    private List<Operator<?>> operands = new ArrayList();

    protected abstract T checkValue(T var1);

    @Override
    public T getValue() {
        T value = this.performOperation(this.operands);
        return this.checkValue(value);
    }

    @Override
    public boolean isValid() {
        boolean fine = true;
        if (this.getMinOperands() >= 0 && this.operands.size() < this.getMinOperands()) {
            fine = false;
        }
        if (fine && this.getMaxOperands() >= 0 && this.operands.size() > this.getMaxOperands()) {
            fine = false;
        }
        return fine;
    }

    protected abstract T performOperation(List<Operator<?>> var1);

    @Override
    public List<Operator> getOperands() {
        ArrayList<Operator> defensiveCopy = new ArrayList<Operator>(this.operands);
        return defensiveCopy;
    }

    @Override
    public void addOperand(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("Cannot add a null operator");
        }
        if (this.operands.contains(operator)) {
            throw new IllegalArgumentException("You've already added that operator.");
        }
        this.operands.add(operator);
    }
}

