/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.operator;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.OperatorFactory;
import au.com.ordermate.operator.OperatorTokeniser;
import ordermate.OrderMate;

public abstract class AbstractOperatorFactory
implements OperatorFactory {
    private static final char OPEN = '(';
    private static final char CLOSE = ')';
    private static final char SEPARATOR = ',';

    @Override
    public Operator createOperator(String operationString) {
        OperatorTokeniser tokeniser = new OperatorTokeniser('(', ')', ',');
        Operator operator = null;
        try {
            OperatorTokeniser.OpToken rootToken = tokeniser.tokenise(operationString);
            operator = this.createOperator(rootToken);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Problem parsing the Operation String :" + operationString, (Throwable)ex);
        }
        return operator;
    }

    protected Operator createOperator(OperatorTokeniser.OpToken token) {
        Operator op = this.makeOperatorFor(token.label);
        if (op != null) {
            for (OperatorTokeniser.OpToken nextOperand : token.subTokens) {
                Operator subOp = this.createOperator(nextOperand);
                if (subOp == null) {
                    throw new IllegalArgumentException("Operation cannot be created.");
                }
                op.addOperand(subOp);
            }
        }
        return op;
    }

    protected abstract Operator makeOperatorFor(String var1);

    @Override
    public String convertToString(Operator op) {
        OperatorTokeniser.OpToken token = this.convertToOpToken(op, null);
        OperatorTokeniser tokeniser = new OperatorTokeniser('(', ')', ',');
        return tokeniser.toString(token);
    }

    private OperatorTokeniser.OpToken convertToOpToken(Operator op, OperatorTokeniser.OpToken parent) {
        OperatorTokeniser.OpToken token = new OperatorTokeniser.OpToken();
        token.label = op.getLabel();
        token.parent = parent;
        for (Operator subOp : op.getOperands()) {
            token.subTokens.add(this.convertToOpToken(subOp, token));
        }
        return token;
    }
}

