/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.operator;

import java.util.ArrayList;
import java.util.List;

public class OperatorTokeniser {
    private final char open;
    private final char close;
    private final char separate;

    public OperatorTokeniser(char open, char close, char separate) {
        this.open = open;
        this.close = close;
        this.separate = separate;
    }

    public OpToken tokenise(String value) {
        if (this.smellsValid(value)) {
            return value.contains("\"") ? this.parseOperationString(value) : this.parseOperationString(value.replace(" ", ""));
        }
        return null;
    }

    protected boolean smellsValid(String operationString) {
        int openCount = 0;
        int closeCount = 0;
        for (int i = 0; i < operationString.length(); ++i) {
            if (this.open == operationString.charAt(i)) {
                ++openCount;
                continue;
            }
            if (this.close != operationString.charAt(i)) continue;
            ++closeCount;
        }
        return openCount == closeCount;
    }

    private OpToken parseOperationString(String value) {
        OpToken current = null;
        int labelStart = 0;
        for (int i = 0; i < value.length(); ++i) {
            OpToken constToken;
            if (value.charAt(i) == this.open) {
                OpToken holder = new OpToken();
                if (current != null) {
                    current.subTokens.add(holder);
                    holder.parent = current;
                }
                current = holder;
                holder.label = value.substring(labelStart, i);
                labelStart = i + 1;
                continue;
            }
            if (current != null && value.charAt(i) == this.close) {
                if (labelStart != i) {
                    constToken = new OpToken();
                    constToken.label = value.substring(labelStart, i);
                    current.subTokens.add(constToken);
                    constToken.parent = current;
                }
                labelStart = i + 1;
                if (current.parent == null) {
                    return current;
                }
                current = current.parent;
                continue;
            }
            if (current == null || value.charAt(i) != this.separate) continue;
            if (value.charAt(i - 1) != this.close) {
                constToken = new OpToken();
                constToken.label = value.substring(labelStart, i);
                current.subTokens.add(constToken);
                constToken.parent = current;
            }
            labelStart = i + 1;
        }
        if (current == null) {
            OpToken constToken = new OpToken();
            constToken.label = value;
            return constToken;
        }
        throw new IllegalStateException("Invalid operator string.");
    }

    public String toString(OpToken token) {
        StringBuilder SB = new StringBuilder();
        this.addToBuilder(token, SB);
        return SB.toString();
    }

    private void addToBuilder(OpToken token, StringBuilder SB) {
        SB.append(token.label);
        int size = token.subTokens.size();
        if (size > 0) {
            SB.append(this.open);
            for (int i = 0; i < size; ++i) {
                this.addToBuilder(token.subTokens.get(i), SB);
                if (i >= size - 1) continue;
                SB.append(this.separate);
            }
            SB.append(this.close);
        }
    }

    public static class OpToken {
        String label;
        OpToken parent;
        List<OpToken> subTokens = new ArrayList<OpToken>();

        public List<OpToken> getSubTokens() {
            return this.subTokens;
        }
    }
}

