/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.operator.date;

import au.com.ordermate.operator.AbstractOperatorFactory;
import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.OperatorTokeniser;
import au.com.ordermate.operator.date.DateOperator;
import au.com.ordermate.operator.date.DateOperatorType;
import au.com.ordermate.operator.date.EndOfDayOperator;
import au.com.ordermate.operator.date.EndOfHourOperator;
import au.com.ordermate.operator.date.EndOfMonthOperator;
import au.com.ordermate.operator.date.EndOfWeekOperator;
import au.com.ordermate.operator.date.LastYearOperator;
import au.com.ordermate.operator.date.MillisDateOperator;
import au.com.ordermate.operator.date.RelativeDateOperator;
import au.com.ordermate.operator.date.StartOfDayOperator;
import au.com.ordermate.operator.date.StartOfFinanceYearOperator;
import au.com.ordermate.operator.date.StartOfHourOperator;
import au.com.ordermate.operator.date.StartOfMonthOperator;
import au.com.ordermate.operator.date.StartOfWeekOperator;
import au.com.ordermate.operator.date.StartOfYearOperator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;

public class DateOperatorFactory
extends AbstractOperatorFactory {
    private List<String> ops;
    private Map<String, Class> typeMap = new HashMap<String, Class>();
    private Date relativeDate;

    public DateOperatorFactory() {
        this.typeMap.put(DateOperatorType.StartOfHour.name().toLowerCase(), StartOfHourOperator.class);
        this.typeMap.put(DateOperatorType.EndOfHour.name().toLowerCase(), EndOfHourOperator.class);
        this.typeMap.put(DateOperatorType.StartOfDay.name().toLowerCase(), StartOfDayOperator.class);
        this.typeMap.put(DateOperatorType.EndOfDay.name().toLowerCase(), EndOfDayOperator.class);
        this.typeMap.put(DateOperatorType.MillisDate.name().toLowerCase(), MillisDateOperator.class);
        this.typeMap.put(DateOperatorType.EndOfWeek.name().toLowerCase(), EndOfWeekOperator.class);
        this.typeMap.put(DateOperatorType.StartOfWeek.name().toLowerCase(), StartOfWeekOperator.class);
        this.typeMap.put(DateOperatorType.StartOfMonth.name().toLowerCase(), StartOfMonthOperator.class);
        this.typeMap.put(DateOperatorType.EndOfMonth.name().toLowerCase(), EndOfMonthOperator.class);
        this.typeMap.put(DateOperatorType.StartOfYear.name().toLowerCase(), StartOfYearOperator.class);
        this.typeMap.put(DateOperatorType.StartOfFinanceYear.name().toLowerCase(), StartOfFinanceYearOperator.class);
        this.typeMap.put(DateOperatorType.LastYear.name().toLowerCase(), LastYearOperator.class);
    }

    public void setRelativeDate(Date value) {
        this.relativeDate = value;
    }

    @Override
    protected Operator createOperator(OperatorTokeniser.OpToken token) {
        DateOperator op = (DateOperator)super.createOperator(token);
        if (token.getSubTokens().isEmpty() && op.getOperands().isEmpty() && op.getMaxOperands() > 0) {
            op.addOperand(new MillisDateOperator(this.relativeDate == null ? new Date() : this.relativeDate));
        }
        return op;
    }

    @Override
    protected Operator makeOperatorFor(String label) {
        String lowerLabel = label.toLowerCase().trim();
        if (this.typeMap.containsKey(lowerLabel)) {
            try {
                Operator op = (Operator)this.typeMap.get(lowerLabel).getConstructor(new Class[0]).newInstance(new Object[0]);
                return op;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot instantiate class of " + this.typeMap.get(label), (Throwable)ex);
                return null;
            }
        }
        try {
            if (lowerLabel.endsWith("l")) {
                return new MillisDateOperator(label.substring(0, label.length() - 1));
            }
            RelativeDateOperator op = new RelativeDateOperator(lowerLabel);
            return op;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot Parse Date for a Day Part Op, 1y 2m 3w 4d, not " + label, (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<String> getOperators() {
        if (this.ops == null) {
            this.ops = new ArrayList<String>();
            for (DateOperatorType type : DateOperatorType.values()) {
                this.ops.add(type.name());
            }
        }
        return this.ops;
    }
}

