/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.operator.date;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.date.DateOperator;
import au.com.ordermate.operator.date.DateOperatorType;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import java.util.List;

public class EndOfWeekOperator
extends DateOperator {
    @Override
    public String getLabel() {
        return DateOperatorType.EndOfWeek.name();
    }

    @Override
    public int getMaxOperands() {
        return 1;
    }

    @Override
    public int getMinOperands() {
        return 1;
    }

    @Override
    protected Date performOperation(List<Operator<?>> operands) {
        Date value = (Date)operands.get(0).getValue();
        if (value != null) {
            return DateTimeUtils.getEndOfDay(DateTimeUtils.getEndDateForWeek(value));
        }
        return null;
    }
}

